<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Checklist;
use App\Models\Pack;
use App\Models\Post;
use App\Models\ChecklistDetail;
use App\Models\ChecklistCount;
use App\Models\Form;
use App\Models\User;
use App\Models\ChecklistForm;

//use App\Models\Checklisttransaction;

class ChecklistController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //return $request;
        if($request->search!=''){
             $checklists=Checklist::with('checklistdetail')->where('title','like', '%'.$request->search.'%')->paginate(10);
        }
        else{
            $checklists= Checklist::with('checklistdetail')->orderBy('created_at','DESC')->paginate(10);
        }
         return view('checklist.index',compact('checklists'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //$id=$id;
        $medias=Pack::select('id','title')->get();
        //return view('checklist.create',compact('medias'));
    }

    public function storeform(Request $request){
        //return $request;
        //$field=$request;
        //return $field;
       $field=$request->formdata;
        //return $field;
       //$form->formsfield =json_encode($request);
        $formval['formsfield'] = json_encode($field);
        $formval['active'] = 1;
        return $formval;
        Form::create($formval);
        



    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return $request;
        $post_id=$request->post_id;
        $id=$request->post_id;
        $check=Checklist::create($request->except('_token','completed','date_completed'));

        //return $request;
        /*$list['id_checklist']=$check->id;
        $list['title']=$request->title;
        $list['description']=$request->description;
        ChecklistDetail::create($list);*/

        $checklists= Checklist::where('post_id',$post_id)->with('checklistdetail')->orderBy('created_at','DESC')->paginate(10);

        /*if($request->completed !=''){
            $list['checklist_id']=$check->id;
            $list['completed']=$request->completed;
            $list['date_completed']=$request->date_completed;
            //return $list;
            Checklisttransaction::create($list);
        }*/
        //return redirect()->route('checklist.show',compact('checklists','id'));
        return view('checklist.index',compact('checklists','post_id'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    
    public function show(Request $request,$id)
    {
        //return $request;
        //return $id;
        $posts=Post::where('id',$id)->select('id','name')->first();
        $post_id=$id;
        if($request->search!=''){
             $checklists=Checklist::where('post_id',$id)->with('checklistdetail')->where('title','like', '%'.$request->search.'%')->paginate(10);
        }
        else{
            $checklists= Checklist::where('post_id',$id)->with('checklistdetail')->orderBy('created_at','DESC')->paginate(10);
        }
        return view('checklist.index',compact('checklists','post_id','posts'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //return $id;
        $checklist= Checklist::with('checklistdetail')->find($id);
        $medias=Pack::select('id','title')->get();
        return view('checklist.edit',compact('checklist','medias'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       //return $request;
        $post_id=$request->post_id;
        $check=Checklist::where('id',$id)->update($request->except('_token','completed','date_completed','_method'));

        /*$list['id_checklist']=$id;
        $list['title']=$request->title;
        $list['description']=$request->description;
        ChecklistDetail::where('id_checklist',$id)->update($list);*/

        $checklists= Checklist::where('post_id',$request->post_id)->with('checklistdetail')->orderBy('created_at','DESC')->paginate(10);

        /*if($request->completed !=''){
            Checklisttransaction::where('checklist_id',$id)->delete();
            $list['checklist_id']=$id;
            $list['completed']=$request->completed;
            $list['date_completed']=$request->date_completed;
            //return $list;
            Checklisttransaction::create($list);
        }*/

        return view('checklist.index',compact('checklists','post_id'));
    }

    public function displayorder(Request $request,$id){
        //return $id;
        //return $request->checklist;
        //return $request;
        //return $request->display;
         $displaycheck=ChecklistDetail::where('id_checklist',$request->checklist)->where('display_sequence',$request->display)->select('id','display_sequence')->first();
         //return count($displaycheck);

        $check=ChecklistDetail::where('id',$id)->where('id_checklist',$request->checklist)->select('id','display_sequence')->first();
        //return $check->display_sequence;
        //for($i=0;$i<count($displaycheck);$i++){
           //$displaycheck[$i]['display_sequence'];
        //if($request->display != $displaycheck['display_sequence']){
           
        if($displaycheck==''){
         $checklist=ChecklistDetail::where('id',$id)->where('id_checklist',$request->checklist)->update(['display_sequence'=>$request->display]);
         return \Response::json(['status'=>"success", 'message'=>'list show successfully.', 'check'=>$check]);
        }else{
            //return 'else';
            return \Response::json(['status'=>"error", 'message'=>'Display sequence already have same value.', 'check'=>$check]);
        }
        //}
        
    }

    public function createchecklist($id){
        //return $id;
        $post=Post::where('id',$id)->select('id','name')->first();
        return view('checklist.create',compact('post'));
    }

    public function newchecklist(Request $request,$id){
        //return $request;
        //return $id;
        if($request->search!=''){
            $search=$request->search;
            //$checklists=ChecklistDetail::with('listdetail')->where('title','like', '%'.$request->search.'%')->first();
            $checklists=Checklist::where('id',$id)->with('checklistdetail','postdetail')->whereHas('checklistdetail',  function($q) use ($search){
                    $q->where('title','like', $search);
                })->first();
        }
        else{
            $checklists=Checklist::where('id',$id)->with('checklistdetail','postdetail')->first();
        }

        $users=User::get();
        $forms=Form::where('active',1)->select('id','title','active')->get();
        return view('checklist.detail',compact('checklists','users','forms'));
    }

    public function formuser(Request $request){
        //return $request;
        $form=Form::where('id',$request['form_id'])->select('id','formsfield')->first();
         for($i = 0; $i< count($request['user_id']); $i++){

                $post['user_id'] = $request['user_id'][$i];
                $post['id_checklist'] = $request['id_checklist'];
                $post['checklist_item_id'] = $request['checklist_item_id'];
                $post['form_id'] = $request['form_id'];
                $post['formsfield'] = $form['formsfield'];
                ChecklistForm::create($post);
        }
        //$checklis=ChecklistForm::create($request->except('_token'));
        return redirect()->back();
 
    }
    public function adddetail($id){
        //return $id;
        $checklist_id=$id;
        $checklists=Checklist::where('id',$id)->select('title')->first();
        $medias=Pack::select('id','title')->get();
        return view('checklist.adddetail',compact('checklist_id','medias','checklists'));
    }

    public function storedetail(Request $request){
        //return $request;
        $check=ChecklistDetail::create($request->except('_token'));
        $id=$request->id_checklist;

        $detail= ChecklistDetail::where('id_checklist',$request->id_checklist)->select('id_checklist')->count();

        

       $list= ChecklistCount::where('id_checklist',$request->id_checklist)->first();
      /* if($list!=''){

        return 'if';
       }
       else{*/

        $ch['id_checklist']=$request->id_checklist;
        $ch['checklist_detail_id']=$check->id;
        $ch['checklist_prompt']=$request->title;
        $ch['checklist_count']=$detail;
        ChecklistCount::create($ch);

       //}
        //return redirect()->back();
        //$checklists=Checklist::where('id',$request->id_checklist)->with('checklistdetail')->first();
        //return view('checklist.detail',compact('checklists'));
        return redirect()->route('newchecklist',compact('id'));

    }

    public function editchecklist($id){
        //return $id;
        $checklists=ChecklistDetail::where('id',$id)->first();
        $medias=Pack::select('id','title')->get();
        return view('checklist.editchecklist',compact('checklists','medias'));
    }

    public function updatechecklist(Request $request,$id){
        //return $request;
        $checklists=ChecklistDetail::where('id',$id)->update($request->except('_token','_method'));
        return redirect()->back();
        //$checklistid=$request->id_checklist;
        //return redirect()->route('newchecklist',compact('checklistid'));
    }


    public function listdetail($id){

        $list =Checklist::where('id',$id)->with('listdetail','mediadetail')->first();
         
         return \Response::json(['status'=>"success", 'message'=>'list show successfully.', 'list'=>$list]);
    }


    public function viewdetail($id){

        $list =ChecklistDetail::where('id',$id)->with('mediadetail')->first();
         
         return \Response::json(['status'=>"success", 'message'=>'list show successfully.', 'list'=>$list]);
    }

    public function listsearch(Request $request){
        //return $request;
        if($request->get('query')!=''){
            $query = $request->get('query');
           
        $list=Checklist::where('title','like', '%'.$query.'%')->select('title as name','id')->get(); 
        }
       return response()->json($list);
    }

    public function detailsearch(Request $request){
        //return $request;
        if($request->get('query')!=''){
            $query = $request->get('query');
           
        $list=ChecklistDetail::where('title','like', '%'.$query.'%')->select('title as name','id')->get(); 
        }
       return response()->json($list);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function listdelete(Request $request, $id){
        try{
            $checklist = Checklist::where('id',$id)->delete();
            return \Response::json(["status" => "success", "message" => "checklist delete"]);
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }

    }

    public function checkdelete(Request $request, $id)
    {
        try{
            $checklist = ChecklistDetail::where('id',$id)->delete();
            return \Response::json(["status" => "success", "message" => "checklist delete"]);
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }
    }
    public function destroy($id)
    {
        //
    }

    public function formshow(){
        return view('checklist.form');
    }
}
