<?php

namespace App\Http\Controllers;

use App\Http\Requests\ClientStoreRequest;
use Illuminate\Http\Request;
use App\Models\Client;

class ClientController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request) {
        //return $request;
        if($request->search!=''){
             $clients = Client::where('name','like', '%'.$request->search.'%')->paginate(10);
        }
        else{
            $clients = Client::paginate(10);
        }

        return view('client.index',compact('clients'));
    }

    public function create()
    {
        
        return view('client.create');
    }

    public function store(Request $request) {
            //return $request;

            if(isset($request->file))
            {

                $image = $request->file('file');
                $fileInfo = $image->getClientOriginalName();
                $uniqueId= time().mt_rand();

                $filename = $uniqueId;
                $extension = pathinfo($fileInfo, PATHINFO_EXTENSION);
                $file_name= $filename.'.'.$extension;
                $image->move('images\upload\client/',$file_name);
                $request['uploadfile']= $file_name;
            }
            //return $request;
           $client= Client::create($request->except('_token','file'));
            return redirect()->route('client.index');
    }

    /**
     * Get single resource
     *
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show(Request $request,$id)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
            //return $id;
            $client= Client::where('id',$id)->first();
            return view('client.edit',compact('client'));
    }

    /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request,$id ) {
        
        if(isset($request->file))
            {

                $image = $request->file('file');
                $fileInfo = $image->getClientOriginalName();
                $uniqueId= time().mt_rand();

                $filename = $uniqueId;
                $extension = pathinfo($fileInfo, PATHINFO_EXTENSION);
                $file_name= $filename.'.'.$extension;
                $image->move('images\upload\client/',$file_name);
                $request['uploadfile']= $file_name;
            }

        $client= Client::where('id',$id)->update($request->except('_token','_method','file'));
        return redirect()->route('client.index');

    }

    public function clientsearch(Request $request)
    {
        if($request->get('query')!=''){
             $query = $request->get('query');
                $searchcategory = Client::where('name','like', '%'.$query.'%')->select('id','name')->get();
        }
        return response()->json($searchcategory);
    }

    public  function clientdelete($id)
    {
       try{
        //return $id;
            $client = Client::where('id',$id)->delete();
            return \Response::json(["status" => "success", "message" => "client delete"]);
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }
    }

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    

    /**
     * Destroy single resource
     *
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy($id ) {
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
}
