<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\MediaType;

class MediaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $mediatype=MediaType::paginate(10);
        return view('media.create',compact('mediatype'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return $request;
        $mediatype=MediaType::create($request->except('_token','Save'));
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //return $id;
         $mediatype=MediaType::where('id',$id)->first();
         return \Response::json(['status'=>"success", 'message'=>'media edit successfully.', 'mediatype'=>$mediatype]); 
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function mediaupdate(Request $request)
    {
        //return $request;
        $mediatype=MediaType::where('id',$request->id)->update($request->except('_token','Save'));
        return redirect()->back();
    }

    public function mediadelete(Request $request,$id){

        try{
            $media = MediaType::where('id',$id)->delete();
            return \Response::json(["status" => "success", "message" => "Media delete"]);
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }
    }



    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    
    public function destroy($id)
    {
        //
    }
}
