<?php
namespace App\Http\Controllers;
use App\User;
use Auth;
use DB;
use App\OrdersMaster;
use App\Http\Requests\OrdersMasterStoreRequest;
use Illuminate\Http\Request;

class OrdersMasterController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index() {


        if(Auth::user()->role_id==NULL)
        {
            $ordermaster = OrdersMaster::with('client')->with('rform')->get();  
        }
        else
        {
            $authId = Auth::user()->id;
           $groups=DB::table('usergroup')
            ->select('usergroup.groupId')->where('usersId', 'LIKE' , "%$authId%")->get();
            $group="";
            
            foreach ($groups as $groupId) {
               $group = $groupId->groupId;
               //$group .= $groupId->groupId . " ";
           
            //echo $group;
          
            
               $steps=DB::table('steps')
               ->select('steps.stageId')->where('userGroup', 'LIKE' , "%$group%")->groupBy('steps.stageId')->get();
               $stage="";
               foreach ($steps as $stageId) {
                   $stage = $stageId->stageId;
//$stage .= $stageId->stageId . " ";
                //  echo "<br>";
                $order="";
               //echo $stage;
               $stages=DB::table('stages')
               ->select('stages.orderId')->where('stageId', '=' , "$stage")->groupBy('stages.orderId')->get();
               foreach ($stages as $orderId) {
                   $order = $orderId->orderId;
                  //echo "<br>";
                  $ordermaster = OrdersMaster::where('routingformId', $order)->with('client')->with('rform')->get(); 
               }
            } 
            
        }
           
          
        }
               
        
        

        return response()->json([
            'data' => $ordermaster
        ]);
    }

    /**
     * Get single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show( OrdersMaster $ordermaster ) {

        return response()->json([
            'data' => $ordermaster
        ]);
    }

    /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update( OrdersMasterStoreRequest $request, OrdersMaster $ordermaster ) {
        $ordermaster->fill($request->all());
		//User Information Details Submit
		$ordermaster->companyId = '1';
		$ordermaster->customerId = '1';
        $ordermaster->save();
        return response()->json([
            'status' => true,
            'data' => $ordermaster
        ]);
    }

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store( OrdersMasterStoreRequest $request ) {
        $ordermaster = new OrdersMaster;
        $ordermaster->fill($request->all());
        //User Id Generate Dynamically.
        $year = date("Y");
        $year = substr( $year, -2);
        $month = date("m");
        //Fetch last company id from CompanyMaster
        $lastorderid=DB::table('orders')
       ->select('orders.orderNo')->OrderBy('orders.orderNo', 'DESC')->first();
        if($lastorderid==NULL){
           
            $bId = "1";
		}
		else{
            $lastorderid = $lastorderid->orderNo;
            $lastorderid = substr( $lastorderid, -6);
            $sequence = $lastorderid + 1;
            $bId = $sequence;
		}
       
        //User Information Details Submit
        $ordermaster->orderNo = $bId;
        $ordermaster->save();

        return response()->json([
            'status' => true,
            'created' => true,
            'data' => [
                'id' => $bId
            ]
        ]);
    }

    /**
     * Destroy single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy( OrdersMaster $ordermaster ) {
       
        $ordermaster->delete();
        //echo "amar";
        return response()->json([
            'status' => true
        ]);
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroyMass( Request $request ) {
        $request->validate([
            'ids' => 'required|array'
        ]);

        OrdersMaster::destroy($request->ids);

        return response()->json([
            'status' => true
        ]);
    }
}
