<?php

namespace App\Http\Controllers;
use App\User;
use Auth;
use DB;
use App\StageMaster;
use App\Http\Requests\StagesMasterStoreRequest;
use Illuminate\Http\Request;

class StagesMasterController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index() {

           // $stagemaster = StageMaster::get();     
        
            if(isset($_REQUEST['filterType'])){
                $filterType = $_REQUEST['filterType'];
              }else{
                  $filterType = false;
              }
    
               if (isset($filterType)) {
                $stagemaster = StageMaster::where('orderId', '=', '' . $filterType . '')->get();
              }
            else
           {
                $stagemaster = StageMaster::get();      
           }

        return response()->json([
            'data' => $stagemaster
        ]);
    }

    /**
     * Get single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show( StageMaster $stagemaster ) {

        return response()->json([
            'data' => $stagemaster
        ]);
    }

    /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update( StagesMasterStoreRequest $request, StageMaster $stagemaster ) {
        $stagemaster->fill($request->all());
		//User Information Details Submit
        $stagemaster->save();
        return response()->json([
            'status' => true,
            'data' => $stagemaster
        ]);
    }

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store( StagesMasterStoreRequest $request ) {
        $stagemaster = new StageMaster;
        $stagemaster->fill($request->all());
        //User Id Generate Dynamically.
        $year = date("Y");
        $year = substr( $year, -2);
        $month = date("m");
        //Fetch last company id from CompanyMaster
        $laststageid=DB::table('stages')
       ->select('stages.stageId')->OrderBy('stages.stageId', 'DESC')->first();
        if($laststageid==NULL){
           
            $bId = "1";
		}
		else{
            $laststageid = $laststageid->stageId;
            $laststageid = substr( $laststageid, -6);
            $sequence = $laststageid + 1;
            $bId = $sequence;
		}
       
        //User Information Details Submit
        $stagemaster->stageId = $bId;
        $stagemaster->orderId = $_REQUEST['filterType'];
        $stagemaster->save();

        return response()->json([
            'status' => true,
            'created' => true,
            'data' => [
                'id' => $bId
            ]
        ]);
    }

    /**
     * Destroy single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy( StageMaster $stagemaster ) {
       
        $stagemaster->delete();
        //echo "amar";
        return response()->json([
            'status' => true
        ]);
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroyMass( Request $request ) {
        $request->validate([
            'ids' => 'required|array'
        ]);

        StageMaster::destroy($request->ids);

        return response()->json([
            'status' => true
        ]);
    }
}
