<?php

namespace App\Http\Controllers;
use Auth;
use DB;
use App\Models\User;
use App\Models\Step;
use App\Models\UserGroup;
use Illuminate\Http\Request;
use App\Models\GroupName;

class StepsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request) {
        //return $request;
        if($request->search!=''){

            $steps=Step::where('stepName','like', '%'.$request->search.'%')->paginate(10);
            //return redirect()->back();
        }
    }

    public function indexstep(Request $request,$id){
        //return $id;
        $stageid=$id;
        if($request->search!=''){

            $steps=Step::where('stepName','like', '%'.$request->search.'%')->where('stageId',$id)->paginate(10);
        }
        else{
            $steps= Step::where('stageId',$id)->groupBy('stepName')->paginate(10);
        }
        return view('step.index',compact('steps','stageid'));
    }

    public function createstep(Request $request,$id){
        //return $id;
        $sid=$id;
        $users=User::get();
        $usergroup=GroupName::get();
        return view('step.create',compact('sid','users','usergroup'));
    }

    public function store(Request $request ) {
        //return $request;

        $usergroup= UserGroup::whereIN('group_id',$request['user_id'])->select('user_id','group_id')->get();

        $groupid=[];
        $userid=[];
           foreach($usergroup as $group){
            array_push($userid, $group['user_id']);
            array_push($groupid,$group['group_id']);
           }
            //return count($groupid);
            //return count($userid);

        for($i = 0; $i< count($userid); $i++){
                
                $post['userGroup'] = $userid[$i];
                $post['group_id']=$groupid[$i];
                //$post['userGroup'] = $request['user_id'][$i];
                $post['stageId']=$request['stageId'];
                $post['stepName'] = $request['stepName'];
                $post['description']= $request['description'];
                $post['label1']= $request['label1'];
                $post['label2']= $request['label2'];
                $post['status']= $request['status'];
                Step::create($post);
        }

            return redirect()->back();
    }

    public function edit($id){
        //return $id;
        $usergroup=GroupName::get();
        $step=Step::where('id',$id)->first();
        $steps=Step::where('stepName',$step->stepName)->where('stageId',$step->stageId)->get();

        $groupid=[];
        $userid=[];
           foreach($steps as $step){
            array_push($userid, $step['user_id']);
            array_push($groupid,$step['group_id']);
           }
           //return $groupid;
        $users=User::get();
        return view('step.edit',compact('step','users','usergroup','steps','groupid'));
    }

    /**
     * Get single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show(  $id ) {

        
    }

    /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update( Request $request, $id ) {
            //return $request;
               // return $id;
        $usergroup= UserGroup::whereIN('group_id',$request['user_id'])->select('user_id','group_id')->get();

        $selstep=Step::where('id',$id)->first();
        $sstep=Step::where('stepName',$selstep->stepName)->where('stageId',$selstep->stageId)->get();
        

        $userid=[];
        $groupid=[];
       foreach($usergroup as $group){
        array_push($userid, $group['user_id']);
        array_push($groupid,$group['group_id']);
       }

       $stepid=[];
       foreach($sstep as $step){
        array_push($stepid,$step['id']);

       }
       //return ($userid);
        //return $groupid;
       //return $stepid;
            //Step::where('id',$id)->

        for($i = 0; $i< count($userid); $i++){
            //return $userid[$i];
            //return Step::where('id',$id)->whereIN('userGroup',$userid)->first();
            //foreach($sstep as $stagestep){
                //return $stagestep;
                //if(!in_array($stagestep->id, $stepid) && ){

                    $post['userGroup'] = $userid[$i];
                    $post['group_id']=$groupid[$i];
                    //$post['userGroup'] = $userid[$i];
                    //$post['userGroup'] = $userid[$i];
                    $post['stageId']=$request['stageId'];
                    $post['stepName'] = $request['stepName'];
                    $post['description']= $request['description'];
                    $post['label1']= $request['label1'];
                    $post['label2']= $request['label2'];
                    $post['status']= $request['status'];
                    Step::where('id',$id)->whereIN('userGroup',$userid)->create($post);

                //}
                /*else{
                    $post['userGroup'] = $userid[$i];
                    $post['group_id']=$groupid[$i];
                    //$post['userGroup'] = $userid[$i];
                    //$post['userGroup'] = $userid[$i];
                    $post['stageId']=$request['stageId'];
                    $post['stepName'] = $request['stepName'];
                    $post['description']= $request['description'];
                    $post['label1']= $request['label1'];
                    $post['label2']= $request['label2'];
                    $post['status']= $request['status'];
                    Step::create($post);
                }*/
            //}
        }

       /* for($i = 0; $i< count($request['user_id']); $i++){

                $post['userGroup'] = $request['user_id'][$i];
                $post['stageId']=$request['stageId'];
                $post['stepName'] = $request['stepName'];
                $post['description']= $request['description'];
                $post['label1']= $request['label1'];
                $post['label2']= $request['label2'];
                $post['status']= $request['status'];
                //return $post;
                Step::where('id',$id)->update($post);
        }*/
         $stageid=$request['stageId'];
        return redirect()->route('indexstep',$stageid);
    }

    public function stepsearch(Request $request){
        //return $request;
        if($request->get('query')!=''){
            $query = $request->get('query');
            //$query=ucfirst($request->query);
        $post=Step::where('stepName','like', '%'.$query.'%')->select('stepName as name','id')->get(); 
        }
       return response()->json($post);
    }

    
    public function stepdelete(Request $request, $id)
    {
        //return  $request;
        try{
            $post = Step::where('id',$id)->delete();
            return \Response::json(["status" => "success", "message" => "Step delete"]);
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }

    }

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    

    /**
     * Destroy single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy(  $id ) {
       
        
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
}
