<?php

namespace App\Http\Controllers;
use App\User;
use Auth;
use DB;
use App\StepMaster;
use App\Http\Requests\StepsMasterStoreRequest;
use Illuminate\Http\Request;

class StepsMasterController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index() {
 if(isset($_REQUEST['filterType'])){
            $filterType = $_REQUEST['filterType'];
          }else{
              $filterType = false;
          }

		   if (isset($filterType)) {
            $stepmaster = StepMaster::where('stageId', '=', '' . $filterType . '')->get();
           
          }
        else
       {
            $stepmaster = StepMaster::get();      
       }

       if(isset($_REQUEST['mStatus'])){
        $steps = $_REQUEST['mStatus'];
      }
       if (isset($steps)) {
        $stepmaster = StepMaster::where('stageId', '=', '' . $steps . '')->with('sites')->get();
      }
      
    
                
        
        

        return response()->json([
            'data' => $stepmaster
        ]);
    }

    /**
     * Get single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show( StepMaster $stepmaster ) {

        return response()->json([
            'data' => $stepmaster
        ]);
    }

    /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update( StepsMasterStoreRequest $request, StepMaster $stepmaster ) {
        $stepmaster->fill($request->all());
        //User Information Details Submit
        $users = $request->userGroup;
        $produ=" ";
             for ($i=0;$i<count($users);$i++)
             {

                    $produ .= $users[$i]." ";

            }	
       $stepmaster->userGroup = $produ;
        $stepmaster->save();
        return response()->json([
            'status' => true,
            'data' => $stepmaster
        ]);
    }

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store( StepsMasterStoreRequest $request ) {
        $stepmaster = new StepMaster;
        $stepmaster->fill($request->all());
        //User Id Generate Dynamically.
        $year = date("Y");
        $year = substr( $year, -2);
        $month = date("m");
        //Fetch last company id from CompanyMaster
        $laststepid=DB::table('steps')
       ->select('steps.stepId')->OrderBy('steps.stepId', 'DESC')->first();
        if($laststepid==NULL){
           
            $bId = "1";
		}
		else{
            $laststepid = $laststepid->stepId;
            $laststepid = substr( $laststepid, -6);
            $sequence = $laststepid + 1;
            $bId = $sequence;
		}
       
         //User Information Details Submit
         $users = $request->userGroup;
         $produ=" ";
              for ($i=0;$i<count($users);$i++)
              {
 
                     $produ .= $users[$i]." ";
 
             }	
        $stepmaster->userGroup = $produ;
        $stepmaster->stepId = $bId;
		$stepmaster->stageId = $_REQUEST['filterType'];
        $stepmaster->save();

        return response()->json([
            'status' => true,
            'created' => true,
            'data' => [
                'id' => $bId
            ]
        ]);
    }

    /**
     * Destroy single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy( StepMaster $stepmaster ) {
       
        $stepmaster->delete();
        //echo "amar";
        return response()->json([
            'status' => true
        ]);
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroyMass( Request $request ) {
        $request->validate([
            'ids' => 'required|array'
        ]);

        StepMaster::destroy($request->ids);

        return response()->json([
            'status' => true
        ]);
    }
}
