<?php

namespace App\Http\Controllers\User\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class LoginController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function showLoginForm(){
        
        return view('user.auth.login');
    }

    public function login(Request $request)
    {
        //return $request;
        $this->validate($request, [
        'email'   => 'required',
        'password' => 'required'
      ]);
      //return Auth::guard("user");
      // Attempt to log the user in
      if (Auth::guard('user')->attempt(['email' => $request->email, 'password' => $request->password])) {
        //return $request;
        //if successful, then redirect to their intended location
        return redirect()->intended(route('user.dashboard'));
      } 
      // if unsuccessful, then redirect back to the login with the form data
      return redirect()->back()->withInput($request->only('email', 'remember'));
    }

    

    protected function authenticated(Request $request, $user) 
    {
        return redirect($this->redirectTo);
    }

    public function logout()
    {
        Auth::guard('user')->logout();
        return redirect('user/login');
    }




    
}
