<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AssignForm;
use App\Models\Step;
//use App\Models\Post;
use App\Models\User;
//use App\Models\ChecklistDetail;
use App\Models\Client;
use Carbon;
use DB;
use App\Models\ChecklistForm;



class UserOrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $id=auth()->guard("user")->id();
         $forms=Step::where('userGroup',$id)->with('stagedetail')->get();

     /* return  $top_donwload_list = DB::table('steps')
    ->selectRaw("steps.id,steps.stepName, stages.stageName,COUNT('stages.id') as stageid")
    ->leftjoin('stages', 'stages.id', '=', 'steps.stageId')
    ->where('steps.userGroup',$id)
    ->groupBy('stages.id')
    //->orderBy('steps.id', 'desc')
    ->get();*/

    /*return  $top_donwload_list = DB::table('stages')
    ->selectRaw("steps.id,steps.stepName, stages.stageName,COUNT('stages.id') as stageid")
    ->leftjoin('steps', 'steps.stageId', '=', 'stages.id')
    ->where('steps.userGroup',$id)
    ->groupBy('stages.id')
    //->orderBy('steps.id', 'desc')
    ->get();*/


    $dataorder = DB::table('stages')
            ->join('steps', 'steps.stageId', '=', 'stages.id')
            ->select(
                'steps.id',
                'steps.stepName',
                'stages.stageName',
                'stages.id AS stageid',
                DB::raw("count(steps.stageId) AS total"))
             ->where('steps.userGroup',$id)
        ->groupBy('steps.stepName')
        ->get();

       return view('userorder.index',compact('dataorder'));
        //$detail= $newval= DB::table('stages')->select(DB::raw('count(stageId) as total'))->where('userGroup',$id)->get();
        //return view('userorder.index',compact('forms'));
    }

    public function customers(){
        
        $id=auth()->guard("user")->id();

        $customerdata= DB::table('stages')
            ->join('steps', 'steps.stageId', '=', 'stages.id')
            ->join('routings', 'routings.id', '=', 'stages.orderId')
            ->leftjoin('orders', 'orders.routingformId', '=', 'stages.orderId')
            ->leftjoin('clients', 'clients.id', '=', 'orders.clientId') 
            ->select(
                'routings.id',
                'routings.routingName',
                'stages.stageName',
                'stages.id AS stageid',
                'clients.name',
                DB::raw("count(steps.stageId) AS total"))
        ->where('steps.userGroup',$id)
        ->groupBy('routings.id')
        ->get();

        return view('userorder.customer',compact('customerdata'));

    }

    public function orderindex($id){
        //return $id;
        $userid=auth()->guard("user")->id();
        $forms=Step::where('userGroup',$id)->with('stagedetail')->get();

        $dataorder = DB::table('orders')
        ->leftjoin('routings', 'routings.id', '=', 'orders.routingformId')
            ->leftjoin('clients', 'clients.id', '=', 'orders.clientId')
            ->select(
                'orders.id',
                'orders.customerName',
                'orders.routingformId',
                'routings.routingName',
                'clients.name',
                'orders.created_at')
              ->where('orders.routingformId',$id)
             
        ->get();

        $stageorder=DB::table('orders')->where('steps.userGroup',$userid)->where('orders.routingformId',$id)->leftjoin('stages', 'stages.orderId', '=', 'orders.routingformId')->join('steps', 'steps.stageId', '=', 'stages.id')->select('orders.id as orderid','orders.routingformId as routingformId' , DB::raw("count(stages.orderId) AS totalstage"))->groupBy('stages.orderId')->get();

        $inprcess=DB::table('orders')->where('orders.routingformId',$id)->leftjoin('stages', 'stages.orderId', '=', 'orders.routingformId')->leftjoin('checklist_forms', 'stages.id', '=', 'checklist_forms.stage_id')->select('orders.id as orderid',  DB::raw("count(stages.orderId) AS totalstage"), DB::raw("count(checklist_forms.stagestatus) AS inprocess"))->where('checklist_forms.stagestatus','InProcess')->groupBy('stages.orderId')->get();

        $completed=DB::table('orders')->where('orders.routingformId',$id)->leftjoin('stages', 'stages.orderId', '=', 'orders.routingformId')->leftjoin('checklist_forms', 'stages.id', '=', 'checklist_forms.stage_id')->select('orders.id as orderid',  DB::raw("count(stages.orderId) AS totalstage"), DB::raw("count(checklist_forms.stagestatus) AS completed"))->where('checklist_forms.stagestatus','completed')->groupBy('stages.orderId')->get();

       return view('userorder.index',compact('dataorder','stageorder','inprcess','completed'));
    }

    public function routingform($id){
        //return $id;
        $userid=auth()->guard("user")->id();
        $forms=Step::where('userGroup',$id)->with('stagedetail')->get();

        $totalcount = DB::table('stages')->where('steps.userGroup',$userid)
            ->join('steps', 'steps.stageId', '=', 'stages.id')->select('steps.id',  'stages.id AS stageid', DB::raw("count(steps.stageId) AS count"))->groupBy('stages.stageName')->get();


        $dataorder = DB::table('stages')
            ->join('steps', 'steps.stageId', '=', 'stages.id')
            ->leftjoin('checklist_forms', 'stages.id', '=', 'checklist_forms.stage_id')
            ->leftjoin('routings', 'routings.id', '=', 'stages.orderId')
            ->leftjoin('orders', 'orders.routingformId', '=', 'stages.orderId') 
            ->leftjoin('clients', 'clients.id', '=', 'orders.clientId')
            ->select(
                'steps.id',
                'steps.stepName',
                'stages.stageName',
                'stages.id AS stageid',
                'routings.routingName',
                'orders.id as orderno',
                'stages.orderId',  'checklist_forms.dateofcompletion','checklist_forms.timeofcompletion','checklist_forms.stagestatus', 'clients.name',
                DB::raw("count(steps.stageId) AS total"))
              //->where('stages.orderId',$id)
            ->where('steps.userGroup',$userid)
        ->groupBy('stages.stageName')
        ->get();

        $steps=[];
        foreach($dataorder as $order){

        $steps = DB::table('stages')
            ->join('steps', 'steps.stageId', '=', 'stages.id')
            ->leftjoin('assign_forms', 'assign_forms.stepId', '=', 'steps.id')
            ->leftjoin('forms', 'forms.id', '=', 'assign_forms.formId')
            ->select(
                'steps.id',
                'steps.stepName',
                'assign_forms.formId',
                'forms.id as formid',
                'forms.title as formname',
                'stages.stageName',
                'stages.id AS stageid')
            ->groupBy('steps.id')
             ->where('steps.userGroup',$userid)
            //->where('stages.orderId',$id)
            ->get();



        }

        $checkform= ChecklistForm::where('user_id',$userid)->where('order_id',$id)->get();

        $stgform= ChecklistForm::where('user_id',$userid)->get();

       // $stageform=ChecklistForm::where('user_id',$userid)->where('order_id',$id)->where()->first();

        $stepform=[];
        $clientid=[];
        $phcad=[];
        $chstageid=[];
        foreach($checkform as $form){
            array_push($stepform, $form->step_id);
            array_push($clientid,$form->client_id);
            array_push($phcad,$form->cad);
            array_push($chstageid,$form->stage_id);
            //in_array($form->step_id, $stepform);

        }

        //return $chstageid;

      // $checkform= ChecklistForm::where('user_id',$userid)->first();
       $clients=Client::get();

    /*$dataorder = DB::table('stages')
            
            ->select(
                'stages.id',
                'stages.stageName')
            ->where('stages.orderId',$id)
        ->groupBy('stages.id')
        ->get();*/

       return view('userorder.routing',compact('dataorder','steps','userid','clients','checkform','stepform','clientid','phcad','chstageid','totalcount'));
    }

    public function submitstep(Request $request){
            //return $request;
        $step['user_id']=auth()->guard("user")->id();

        $step['step_id']= $request['id'];
            $step['stage_id']= $request['stageid'];
            $step['form_id']= $request['formid'];
            $step['order_id']= $request['orderid'];
            $step['client_id']= $request['client'];

            $step['status']=$request['status'];
            $step['cad']=$request['cad'];

        if($request['formid']!=''){
            $chform=ChecklistForm::where('user_id',$step['user_id'])->where('form_id',$request['formid'])->where('step_id',$request['id'])->first();
        }else{

            $chform=ChecklistForm::where('user_id',$step['user_id'])->where('step_id',$request['id'])->first();
        }

        if($request['formid'] && $chform!=''){
            //return 'if';
            ChecklistForm::where('user_id',$step['user_id'])->where('form_id',$request['formid'])->update($step);
        }
        elseif($request['formid']=='' && $chform!=''){
            ChecklistForm::where('user_id',$step['user_id'])->where('step_id',$request['id'])->update($step);
        }
        else{
           // return 'else';
            ChecklistForm::create($step);
        }
           
        return Response()->json(['status'=>'success','step'=>$step]);
    }

    public function submitstage(Request $request){
            //return $request;
            $stage['user_id']=auth()->guard("user")->id();
            $stage['step_id']= $request['id'];
            $stage['stage_id']= $request['stageid'];
            $stage['form_id']= $request['formid'];
            $stage['order_id']= $request['orderid'];
            $stage['dateofcompletion']=$request['datacompl'];
            $stage['timeofcompletion']=$request['timecompl'];
            $stage['stagestatus']=$request['status'];

            //return $stage;
        if($request['formid']!=''){
           // return 'if';
            $chform=ChecklistForm::where('user_id',$stage['user_id'])->where('stage_id',$request['stageid'])->where('form_id',$request['formid'])->first();
        }else{
          // return 'else';
            $chform=ChecklistForm::where('user_id',$stage['user_id'])->where('stage_id',$request['stageid'])->first();
        }

        $chsteps=ChecklistForm::where('stage_id', $request['stageid'])->select('id','step_id','stage_id')->get();

        $steps=Step::where('stageId', $request['stageid'])->select('id','stageId')->first();

        $stagestep=[];
        foreach($chsteps as $step){
            array_push($stagestep,$step->step_id);
        }
        //return $stagestep;

        if($request['formid'] && $chform!=''){
            //return 'if';
             ChecklistForm::where('user_id',$stage['user_id'])->where('form_id',$request['formid'])->where('stage_id',$request['stageid'])->update(['user_id'=> $stage['user_id'],'stage_id'=>$request->stageid,'form_id'=>$request->formid,'order_id'=>$request->orderid,'dateofcompletion'=>$request->datacompl,'timeofcompletion'=>$request->timecompl,'stagestatus'=>$request->status]);
        }
        elseif($request['formid']=='' && $chform!='' && $chsteps!=''){
            //return 'elseif';
            ChecklistForm::where('user_id',$stage['user_id'])->where('stage_id',$request['stageid'])->whereIN('step_id',$stagestep)->update(['user_id'=> $stage['user_id'],'stage_id'=>$request->stageid,'order_id'=>$request->orderid,'dateofcompletion'=>$request->datacompl,'timeofcompletion'=>$request->timecompl,'stagestatus'=>$request->status]);
        }
        elseif($request['formid']=='' && $chform!=''){
            //return 'ifelse';
            ChecklistForm::where('user_id',$stage['user_id'])->where('stage_id',$request['stageid'])->whereIN('step_id', $stage['step_id'])->update(['user_id'=> $stage['user_id'],'stage_id'=>$request->stageid,'order_id'=>$request->orderid,'dateofcompletion'=>$request->datacompl,'timeofcompletion'=>$request->timecompl,'stagestatus'=>$request->status]);

        }
        else{
            //return 'else';
            ChecklistForm::create($stage);
        }

        //ChecklistForm::create($stage);

        return Response()->json(['status'=>'success','stage'=>$stage]);
    }

    public function stepform($id,$stepid){
        //return $id;
        $step_id=$stepid;
        $forms=AssignForm::where('stepId',$step_id)->where('formId',$id)->with('formdetail')->first(); 
        //$forms=ChecklistForm::where('step_id',$step_id)->where('form_id',$id)->with('formdetail')->first();
      return view('user.userchecklist.form',compact('forms','step_id'));
    }

    public function updatestepform(Request $request,$id){
        //return $request;
        // return $id;
            //return $request;
            $user_id=auth()->guard("user")->id();

            $ch= ChecklistForm::where('step_id',$request->step_id)->where('form_id',$request->id)->first();
            if($ch!=''){
               // return 'if' ;
               $chf= ChecklistForm::where('step_id',$request->step_id)->where('form_id',$request->id)->update(['formsfield'=>$request->formfield,'user_id'=>$user_id]);
            }

        return redirect()->back();
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request,$id)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        


    }

    public function viewchecklist($id){
    }

    public function search(Request $request){
       
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
