<?php

namespace App\Http\Controllers;
use Auth;
use DB;
use App\Models\UserGroup;
use App\Models\User;
use Illuminate\Http\Request;
use App\Models\GroupName;

class UserGroupController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index() {

        $users= User::get();

        $usergroups = GroupName::with('groupdetail')->paginate(10);

        $detailid=[];
        foreach($usergroups as $usergroup){
          foreach($usergroup->groupdetail as $detail){
            array_push($detailid, $detail->user_id);
          }   
        }  
        //return $detailid;
        return view('usergroup.index',compact('usergroups','detailid','users'));

    }

    public function create()
    {
        $users= User::get();
    
        return view('usergroup.create',compact('users'));
    }

    public function store(Request $request ) {
        //return $request;
        $group['groupname']=$request->groupName;
        $groups=GroupName::create($group);

         for($i = 0; $i< count($request['user_id']); $i++){

                $post['user_id'] = $request['user_id'][$i];
                $post['group_id'] = $groups->id;
                UserGroup::create($post);
        }

        return redirect()->back();
        
    }

    public function edit($id){
        //return $id;
         $usergroups = GroupName::where('id',$id)->with('groupdetail')->first();
        //$usergroup=UserGroup::where('id',$id)->first();
         $detailid=[];
          foreach($usergroups->groupdetail as $detail){
            array_push($detailid, $detail->user_id);
          }
          //return  $detailid;
        $users= User::get();

        return view('usergroup.edit',compact('usergroups','users','detailid'));
    }

    /**
     * Get single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show(  $id ) {

        
    }

    /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request,$id ) {
        //return $request;
       // return $id;
        $group['groupname']=$request->groupName;
        $groups=GroupName::where('id',$id)->update($group);

         UserGroup::where('group_id',$id)->delete();
         for($i = 0; $i< count($request['user_id']); $i++){

                $post['user_id'] = $request['user_id'][$i];
                $post['group_id'] = $id;
                UserGroup::create($post);
        }

        return redirect()->route('usergroup.index');
    }

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */

    /**
     * Destroy single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy( UserGroup $usergroup ) {
       
        $usergroup->delete();
        //echo "amar";
        return response()->json([
            'status' => true
        ]);
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroyMass( Request $request ) {
        $request->validate([
            'ids' => 'required|array'
        ]);

        UserMaster::destroy($request->ids);

        return response()->json([
            'status' => true
        ]);
    }
}
