<?php

namespace App\Http\Controllers;
use App\User;
use Auth;
use DB;
use App\UserMaster;
use App\Http\Requests\UsersMasterStoreRequest;
use Illuminate\Http\Request;

class UsersMasterController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index() {

            $usermaster = UserMaster::where('role_id', '=', '1')->get();     
        
        

        return response()->json([
            'data' => $usermaster
        ]);
    }

    /**
     * Get single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show( UserMaster $usermaster ) {

        return response()->json([
            'data' => $usermaster
        ]);
    }

    /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update( UsersMasterStoreRequest $request, UserMaster $usermaster ) {
        $usermaster->fill($request->all());
		//User Information Details Submit
		//$usermaster->file_id = '1';
		//$usermaster->customerId = '1';
		//$usermaster->password = bcrypt($request->password);
        $usermaster->save();
        return response()->json([
            'status' => true,
            'data' => $usermaster
        ]);
    }

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store( UsersMasterStoreRequest $request ) {
        $usermaster = new UserMaster;
        $usermaster->fill($request->all());
        //User Id Generate Dynamically.
        $year = date("Y");
        $year = substr( $year, -2);
        $month = date("m");
        //Fetch last company id from CompanyMaster
        $lastuserid=DB::table('users')
       ->select('users.id')->OrderBy('users.id', 'DESC')->first();
        if($lastuserid==NULL){
           
            $bId = "1";
		}
		else{
            $lastuserid = $lastuserid->id;
            $lastuserid = substr( $lastuserid, -6);
            $sequence = $lastuserid + 1;
            $bId = $sequence;
		}
       
        //User Information Details Submit
		$usermaster->password = bcrypt($request->password);
		$usermaster->role_id = '1';
        $usermaster->id = $bId;
        $usermaster->save();

        return response()->json([
            'status' => true,
            'created' => true,
            'data' => [
                'id' => $bId
            ]
        ]);
    }

    /**
     * Destroy single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy( UserMaster $usermaster ) {
       
        $usermaster->delete();
        //echo "amar";
        return response()->json([
            'status' => true
        ]);
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroyMass( Request $request ) {
        $request->validate([
            'ids' => 'required|array'
        ]);

        UserMaster::destroy($request->ids);

        return response()->json([
            'status' => true
        ]);
    }
}
