<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateChecklistTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('checklist_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('completed')->nullable();
            $table->date('date_completed')->nullable();
            $table->unsignedBigInteger('checklist_id')->nullable();
            $table->timestamps();
            $table->foreign('checklist_id')->references('id')->on('checklists')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('checklist_transactions');
    }
}
