@extends('inventory.layout') 
@section('title', 'Edit Media Library')
@section('content')
    <!-- push external head elements to head -->
    @push('head')
        <link rel="stylesheet" href="{{ asset('plugins/select2/dist/css/select2.min.css') }}">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.css">
        <style type="text/css">
            .gsterror{
                color: red;
            }
            .emailerror{
                color: red;
            }
            .gstverify{
                color: #4b9732;
            }
            .protable{
                overflow-x: auto;
            }
        </style>
    @endpush

    
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <!-- <i class="ik ik-user-plus bg-blue"></i> -->
                        <div class="d-inline">
                            <h5>{{ __('Edit Media Library')}}</h5>
                            
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">{{ __('Edit Media Library')}}</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <form class="forms-sample" method="POST" action="{{ route('medialibrary.update',$pack->id) }}" enctype= multipart/form-data id="Postform">
        @csrf
        @Method('PUT')
        @include('include.message')

            <div class="row">
                <!-- start message area-->
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-header">
                            <strong><h3>{{ __('Basic Information')}}</h3></strong>
                        </div>
                        <div class="card-body">
                            
                            <div class="row">
                            
                                <div class="col-sm-6">    
                                    <div class="form-group">
                                        <label for="post_name">Title<span class="text-red">*</span></label>
                                        <input id="title" type="text" class="form-control" name="title" value="{{isset($pack->title) ? $pack->title:''}}" placeholder="Enter Title" required="">
                                    </div>
                                </div>
                                

                                <div class="col-sm-6">
                                    <div class="form-group">
                                       <label class="d-block">Document Type</label>
                                       <select  class="form-control document" name="document_type_id" id="document" >

                                            <option value="">Select Document Type</option> 
                                            @foreach($documentype as $document)
                                                @if($document->id==$pack->document_type_id)
                                                    <option value="{{$document->id}}" selected="true" > {{$document->name}}</option>
                                                @else  
                                                    <option value="{{$document->id}}">{{$document->name}}</option> 
                                                @endif
                                                    
                                            @endforeach
                                            
                                        </select>
                                        
                                        </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="description">Description</label>
                                        <textarea class="form-control description" name="description" rows="2">{{isset($pack->description) ? $pack->description:''}}</textarea>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                           <label class="d-block">Media Type</label>
                                           <select  class="form-control parentcat" name="media_type_id" id="progroup">

                                                <option value="">Select Media Type</option> 
                                               
                                                @foreach($mediatype as $media)
                                                @if($media->id==$pack->media_type_id)
                                                    <option value="{{$media->id}}" selected="true" > {{$media->name}}</option>
                                                @else  
                                                    <option value="{{$media->id}}">{{$media->name}}</option> 
                                                @endif
                                                @endforeach
                                            
                                            </select>
                                            
                                        </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="duties">Document Upload</label><br>
                                        <input class="" type="file" name="file" id="upload_file">
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="duties">File URL</label>
                                        <input type="text" class="form-control " name="file_url" value="{{isset($pack->file_url) ? $pack->file_url:''}}">
                                    </div>
                                </div>
                            </div>  
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- start message area-->
                
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-body">
                            <div class="col-md-12" style="text-align: center;">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">{{ __('Update')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <!-- push external js -->
    @push('script') 
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
    <script type="text/javascript">

    var route = "{{ url('searchclient') }}";
    $('#client_name').typeahead({
            source: function (query, process) {
                return $.get(route, {
                    query: query
                }, function (data) {
                    console.log(data);
                    return process(data);
                });
            }
        });
    
    </script>
 

     
    @endpush
@endsection
