@extends('inventory.layout') 
@section('title', 'Media Library')
@section('content')
 @push('head')
  
  <style>
    .error{
      color: red;
    }
    /*.searchclass{
        text-transform:capitalize;
    }*/
    .tradeadd{
        background-color: #2dce89;
        border-color: #2dce89;
        color:#fff !important;
    }
    .tradeadd:hover{
    background-color:#2dce89;
    border-color: #2dce89;
    }
    .showmedia{
        padding-right: 10px;
    }


  </style>
  @endpush
    <!-- push external head elements to head --> 
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <!-- <i class="ik ik-users bg-green"></i> -->
                        <div class="d-inline">
                            <h5>Media Library</h5>
                            <span>View, delete and update media library</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">Media Library</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <div class="row">
            <!-- list layout 1 start -->
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header row">
                       
                        <div class="col col-sm-6">
                            <div class="card-search with-adv-search dropdown">
                                <form action="{{route('medialibrary.index')}}" method="get">
                                    <input type="text" class="form-control global_filter searchclass" id="search" name="search" placeholder="Search.." >
                                    <button type="submit" class="btn btn-icon"><i class="ik ik-search"></i></button>
                                    <button type="button" id="adv_wrap_toggler_1" class="adv-btn ik ik-chevron-down dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></button>
                                    
                                </form>
                            </div>
                        </div>
                        <div class="col col-sm-5">
                            <div class="card-options text-right">
                                <span class="mr-5" id="top">{{($packs->currentpage()-1)*$packs->perpage()+1}} to {{$packs->currentpage()*$packs->perpage()}}
                                            of  {{$packs->total()}} entries</span>
                                <a href="#"><i class="ik ik-chevron-left"></i></a>
                                <a href="#"><i class="ik ik-chevron-right"></i></a>
                                <a href="{{route('medialibrary.create')}}" class=" btn btn-outline-primary btn-semi-rounded tradeadd"><i class="ik ik-plus"></i>&nbsp;Add Media Library</a>
                            </div>
                           
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="product_table" class="table">
                            <thead>
                                <tr>
                                    
                                    <th>{{ __('Title')}}</th>
                                    <th>{{ __('Document Type')}}</th>
                                    <th>{{ __('Media Type')}}</th>
                                    
                                    <th>{{ __('Status')}}</th>
                                    <th style="width: 90px;!important">{{ __('Action')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($packs as $pack)
                                <tr>
                                    
                                    <td>{{ isset($pack->title) ? $pack->title :'' }}</td>
                                    
                                    <td>{{ isset($pack->documentdetail->name) ? $pack->documentdetail->name :'' }}</td>

                                    <td>{{ isset($pack->mediadetail->name) ? $pack->mediadetail->name :'' }}</td>
                                    <td>
                                        <select class="form-control chngstatus" name="status" data-id="{{ isset($pack->id) ? $pack->id :'' }}" id="clientstatus" data-url="{{route('poststatus',$pack['id'])}}" style="width:120px;">

                                            <option value="">Select Status</option> 
                                            @if(isset($pack->status) && $pack->status==1 || $pack->status== 0 )
                               
                                                <option value="1"  {{ ($pack->status) == '1' ? 'selected' : '' }}>Active</option>

                                                <option value="0" @if ($pack->status == '0') {{ 'selected' }} @endif>Inactive</option>
                                                        
                                            @else

                                                <option value="1">Active</option> 
                                                <option value="0">Inactive</option>
                                            @endif 
                                        </select>
                                    </td>
                                    
                                    <td> 

                                        <a href="javascript:;"  class="detailbyid"  data-id="{{ isset($pack->id) ? $pack->id:'' }}" data-url="{{url('mediadetail', $pack['id']) }}"><i class="fa fa-eye text-green"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                        <a href="{{route('medialibrary.edit', $pack->id) }}"  ><i class="ik ik-edit-2  text-green"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                                        <a href="javascript:;" class="deletebyid" data-id="{{ isset($pack->id) ? $pack->id:'' }}"  data-url="{{route('librarydelete',$pack['id'])}}"><i class="ik ik-trash-2 f-16 text-red"></i></a>
                                        
                                        
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                        <div class="card-footer d-flex align-items-center">

                                <div class="col-md-6">
                                </div>
                                
                                <div class="col-md-6">
                                {{ $packs->links('include.pagination') }}
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- list layout 1 end -->
            <div class="col-md-12"><hr></div>
            <!-- list layout 2 -->
            
            <!-- list layout 2 end -->
        </div>
    </div>
    
    <!-- category add modal-->
    <div class="modal fade edit-layout-modal pr-0 show" id="productView" tabindex="-1" role="dialog" aria-labelledby="productViewLabel" style="padding-right: 17px; display: none;" aria-modal="true">
      <div class="modal-dialog" role="document">
          <div class="modal-content">
              <div class="modal-header">
                  <h5 class="modal-title postname" id="productViewLabel"></h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
              </div>
              <div class="modal-body">
                  <div class="row">
                      <div class="col-12 appendimg">
                          
                      </div>
                  </div>
            
                          
              </div>
          </div>
      </div>

    </div>

@push('script')
<script src="{{ url('js/global.js')}}"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
<script src = "http://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>

<script type="text/javascript">

    var route = "{{ url('mediasearch') }}";
 $('#search').typeahead({
            source: function (query, process) {
                return $.get(route, {
                    query: query
                }, function (data) {
                    console.log(data);
                    return process(data);
                });
            }
        });

 /*$(document).ready(function () {
    $('#product_table').DataTable({
        order: [[3, 'desc']],
    });
});*/
var table = $('#product_table').DataTable({

        paging: false,
        ordering: true,
        info: false,
        searching:false,
    });

</script>
 @endpush
 @endsection