@extends('inventory.layout') 
@section('title', 'Permission')
@section('content')
 @push('head')
  
  <style>
    .error{
      color: red;
    }
    /*.searchclass{
        text-transform:capitalize;
    }*/
    .tradeadd{
        background-color: #2dce89;
        border-color: #2dce89;
        color:#fff !important;
    }
    .tradeadd:hover{
    background-color:#2dce89;
    border-color: #2dce89;
    }
    .showmedia{
        padding-right: 10px;
    }


  </style>
  @endpush
    <!-- push external head elements to head --> 
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <!-- <i class="ik ik-users bg-green"></i> -->
                        <div class="d-inline">
                            <h5>Permission</h5>
                            <span>View, delete and update permission</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">Permission</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <div class="row">
            <!-- list layout 1 start -->
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header row">
                       
                        <div class="col col-sm-6">
                            <div class="card-search with-adv-search dropdown">
                                <form action="{{url('permission')}}" method="get">
                                    <input type="text" class="form-control global_filter searchclass" id="search" name="search" placeholder="Search.." >
                                    <button type="submit" class="btn btn-icon"><i class="ik ik-search"></i></button>
                                    <button type="button" id="adv_wrap_toggler_1" class="adv-btn ik ik-chevron-down dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></button>
                                    
                                </form>
                            </div>
                        </div>
                        <div class="col col-sm-5">
                            <div class="card-options text-right">
                                <span class="mr-5" id="top">{{($permissions->currentpage()-1)*$permissions->perpage()+1}} to {{$permissions->currentpage()*$permissions->perpage()}}
                                            of  {{$permissions->total()}} entries</span>
                                <a href="#"><i class="ik ik-chevron-left"></i></a>
                                <a href="#"><i class="ik ik-chevron-right"></i></a>
                                <button class="btn btn-outline-primary btn-rounded-20 tradeadd" href="#permissionAdd" data-toggle="modal" data-target="#permissionAdd">
                                <i class="ik ik-plus"></i>&nbsp;Add Permission
                            </button>
                            </div>
                           
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="product_table" class="table">
                            <thead>
                                <tr>
                                    
                                    <th>{{ __('Permission')}}</th>
                                    <th>{{ __('Assigned Role')}}</th>
                                    <th>{{ __('Action')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                               @foreach($permissions as $permission)
                                  <tr>
                                    <td>{{ isset($permission->name) ? $permission->name :'' }}</td>
                                    <td>
                                        @foreach($permission->roles as $role)
                                        <span class="badge badge-dark m-1">{{ isset($role->name) ? $role->name :'' }}</span>
                                        @endforeach
                                    </td>
                                    
                            
                                    
                                    <td>
                                     
                                    <a href="javascript:;" class="deletebyid" data-id="{{ isset($permission->id) ? $permission->id:'' }}"  data-url="{{url('permission/delete/'.$permission['id'])}}"><i class="ik ik-trash-2 f-16 text-red"></i></a></td>
                                  </tr>
                                @endforeach

                            </tbody>
                        </table>
                        <div class="card-footer d-flex align-items-center">

                            <div class="col-md-6">
                            </div>
                            
                            <div class="col-md-6">
                            {{ $permissions->links('include.pagination') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- list layout 1 end -->
            <div class="col-md-12"><hr></div>
            <!-- list layout 2 -->
            
            <!-- list layout 2 end -->
        </div>
    </div>
    <div class="modal fade edit-layout-modal pr-0 " id="permissionAdd" tabindex="-1" role="dialog" aria-labelledby="permissionAddLabel" aria-hidden="true">
        <div class="modal-dialog w-300" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="categoryAddLabel">{{ __('Add Permission')}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <form class="forms-sample" method="POST" action="{{url('permission/create')}}">
                    @csrf
                  <div class="modal-body">
                    <span id="publicurl" data-value="{{url('/')}}"></span>
                      <div class="form-group">
                            <label class="d-block">Permission</label>
                            <input type="text" class="form-control" id="permission" name="name" placeholder="Permission Name" required>
                      </div>
                      <div class="form-group">
                          <label for="exampleInputEmail3">{{ __('Assigned to Role')}} </label>
                                {!! Form::select('roles[]', $roles, null,[ 'class'=>'form-control select2', 'multiple' => 'multiple']) !!}
                      </div>
                      
                      <div class="form-group">
                          <button type="submit" class="btn btn-primary btn-rounded">{{ __('Save')}}</button>
                      </div>
                  </div>
                </form>
            </div>
        </div>
    </div>

@push('script')
<script src="{{ url('js/global.js')}}"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
<script src = "http://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>

<script type="text/javascript">

    var route = "{{ url('permissionsearch') }}";
 $('#search').typeahead({
            source: function (query, process) {
                return $.get(route, {
                    query: query
                }, function (data) {
                    console.log(data);
                    return process(data);
                });
            }
        });

 /*$(document).ready(function () {
    $('#product_table').DataTable({
        order: [[3, 'desc']],
    });
});*/
var table = $('#product_table').DataTable({

        paging: false,
        ordering: true,
        info: false,
        searching:false,
    });

</script>
 @endpush
 @endsection