@extends('inventory.layout') 
@section('title', 'User Group')
@section('content')
 @push('head')
  
  <style>
    .error{
      color: red;
    }
    /*.searchclass{
        text-transform:capitalize;
    }*/
    .tradeadd{
        background-color: #2dce89;
        border-color: #2dce89;
        color:#fff !important;
    }
    .tradeadd:hover{
    background-color:#2dce89;
    border-color: #2dce89;
    }
    .showmedia{
        padding-right: 10px;
    }


  </style>
  @endpush
    <!-- push external head elements to head --> 
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <!-- <i class="ik ik-users bg-green"></i> -->
                        <div class="d-inline">
                            <h5>User Group</h5>
                            <span>View, delete and update user group</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">User Group</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <div class="row">
            <!-- list layout 1 start -->
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header row">
                       
                        <div class="col col-sm-6">
                            <div class="card-search with-adv-search dropdown">
                                <form action="{{route('routing.index')}}" method="get">
                                    <input type="text" class="form-control global_filter searchclass" id="search" name="search" placeholder="Search.." >
                                    <button type="submit" class="btn btn-icon"><i class="ik ik-search"></i></button>
                                    <button type="button" id="adv_wrap_toggler_1" class="adv-btn ik ik-chevron-down dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></button>
                                    
                                </form>
                            </div>
                        </div>
                        <div class="col col-sm-5">
                            <div class="card-options text-right">
                                <span class="mr-5" id="top">{{($usergroups->currentpage()-1)*$usergroups->perpage()+1}} to {{$usergroups->currentpage()*$usergroups->perpage()}}
                                            of  {{$usergroups->total()}} entries</span>
                                <a href="#"><i class="ik ik-chevron-left"></i></a>
                                <a href="#"><i class="ik ik-chevron-right"></i></a>
                                <a href="{{route('usergroup.create')}}" class=" btn btn-outline-primary btn-semi-rounded tradeadd"><i class="ik ik-plus"></i>&nbsp;Add User Group</a>
                            </div>
                           
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="product_table" class="table">
                            <thead>
                                <tr>
                                    <th>{{ __('Sr. No')}}</th>
                                    <th>{{ __('Group Name')}}</th>
                                    
                                    <th>{{ __('User Id')}}</th>
                                    <th style="width: 150px;!important">{{ __('Action')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($usergroups as $i=>$usergroup)
                                <tr>
                                      <td>{{ $i+1 }}</td>
                                  
                                      <td>{{ (isset($usergroup->groupname) ? $usergroup->groupname:'') }}</td>
                                        @foreach($usergroup->groupdetail as $j=>$detail)
                                                {{--$detail--}}
                                               
                                        @if(in_array($detail->user_id,$detailid))
                                        
                                          @if($j==0)
                                           <td>{{ (isset($detail->user_id) ? $detail->user_id:'') }}
                                          @else
                                                
                                            {{','.$detail->user_id}}</td>
                                          @endif
                                          
                                        @endif
                                        
                                      @endforeach
                                    <td>   

                                        <a href="{{route('usergroup.edit',$usergroup->id)}}" ><i class="ik ik-edit-2 text-green"></i></a>&nbsp;&nbsp;&nbsp;

                                        <a href="javascript:;" class="deletegroupid" data-id="{{ isset($usergroup->id) ? $usergroup->id:'' }}" data-url="{{url('groupdelete', $usergroup['id']) }}"><i class="ik ik-trash-2  text-red"></i></a>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                        <div class="card-footer d-flex align-items-center">

                                <div class="col-md-6">
                                </div>
                                
                                <div class="col-md-6">
                                {{ $usergroups->links('include.pagination') }}
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- list layout 1 end -->
            <div class="col-md-12"><hr></div>
            <!-- list layout 2 -->
            
            <!-- list layout 2 end -->
        </div>
    </div>
    
    <!-- category add modal-->
    
    <div class="modal fade edit-layout-modal pr-0 show" id="postView" tabindex="-1" role="dialog" aria-labelledby="productViewLabel" style="padding-right: 17px; display: none;" aria-modal="true">
      <div class="modal-dialog" role="document">
          <div class="modal-content">
              <div class="modal-header">
                  <h5 class="modal-title catname" id="productViewLabel"></h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
              </div>
              <div class="modal-body">
                  <div class="row">
                      <div class="col-12 appendimg">
                          
                      </div>
                  </div>
            
                          
              </div>
          </div>
      </div>

    </div>

@push('script')
<script src="{{ url('js/global.js')}}"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
<script src = "http://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>

<script type="text/javascript">

    var route = "{{ url('routingsearch') }}";
 $('#search').typeahead({
            source: function (query, process) {
                return $.get(route, {
                    query: query
                }, function (data) {
                    console.log(data);
                    return process(data);
                });
            }
        });

 /*$(document).ready(function () {
    $('#product_table').DataTable({
        order: [[3, 'desc']],
    });
});*/
var table = $('#product_table').DataTable({

        paging: false,
        ordering: true,
        info: false,
        searching:false,
    });

</script>
 @endpush
 @endsection