<?php $__env->startSection('title', 'Permission'); ?>
<?php $__env->startSection('content'); ?>
    <!-- push external head elements to head -->
    <?php $__env->startPush('head'); ?>
        <link rel="stylesheet" href="<?php echo e(asset('plugins/DataTables/datatables.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('plugins/select2/dist/css/select2.min.css')); ?>">
    <?php $__env->stopPush(); ?>


    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <i class="ik ik-unlock bg-blue"></i>
                        <div class="d-inline">
                            <h5><?php echo e(__('Permissions')); ?></h5>
                            <span><?php echo e(__('Define permissions of user')); ?></span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../index.html"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#"><?php echo e(__('Permissions')); ?></a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <div class="row clearfix">
            <!-- start message area-->
            <?php echo $__env->make('include.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- end message area-->
            <!-- only those have manage_permission permission will get access -->
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage_permission')): ?>
            <div class="col-md-12">
                <div class="mb-2 clearfix">
                    <a class="btn pt-0 pl-0 d-md-none d-lg-none" data-toggle="collapse" href="#displayOptions" role="button" aria-expanded="true" aria-controls="displayOptions">
                        <?php echo e(__('Display Options')); ?>

                        <i class="ik ik-chevron-down align-middle"></i>
                    </a>
                    <div class="collapse d-md-block display-options" id="displayOptions">
                        <div class="d-block d-md-inline-block">
                            
                            <div class="search-sm d-inline-block float-md-left mr-1 mb-1 align-top">
                                <form action="<?php echo e(url('permission')); ?>" method="get">
                                    <input type="text" class="form-control" id="search" placeholder="Search.." name="name" value="<?php echo e(Request::input('name')); ?> ">
                                    <button type="submit" class="btn btn-icon"><i class="ik ik-search"></i></button>
                                    
                                    <button type="button" id="adv_wrap_toggler" class="adv-btn ik ik-chevron-down dropdown-toggle" data-toggle="dropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></button>
                                    <div class="adv-search-wrap dropdown-menu dropdown-menu-right" aria-labelledby="adv_wrap_toggler">
                                        <div class="form-group">
                                            <input type="text" class="form-control" placeholder="Category Title">
                                        </div>
                                        
                                        <button class="btn btn-theme"><?php echo e(__('Search')); ?></button>
                                    </div>
                                </form> 
                            </div>
                        </div>
                        
                        <div class="float-md-right">

                    
                            <button class="btn btn-outline-primary btn-rounded-20" href="#permissionAdd" data-toggle="modal" data-target="#permissionAdd">
                                Add Permission
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card p-3">
                    <div class="card-body">
                        <table id="permission_table" class="table">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Permission')); ?></th>
                                    <th><?php echo e(__('Assigned Role')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <tr>
                                    <td><?php echo e(isset($permission->name) ? $permission->name :''); ?></td>
                                    <td>
                                        <?php $__currentLoopData = $permission->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge badge-dark m-1"><?php echo e(isset($role->name) ? $role->name :''); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    
                            
                                    
                                    <td>
                                     
                                    <a href="javascript:;" class="deletebyid" data-id="<?php echo e(isset($permission->id) ? $permission->id:''); ?>"  data-url="<?php echo e(url('permission/delete/'.$permission['id'])); ?>"><i class="ik ik-trash-2 f-16 text-red"></i></a></td>
                                  </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                             
                            </tbody>
                        </table>
                        <div class="card-footer d-flex align-items-center">
                            <div class="col-md-6">
                                Showing <?php echo e(($permissions->currentpage()-1)*$permissions->perpage()+1); ?> to <?php echo e($permissions->currentpage()*$permissions->perpage()); ?>

                                    of  <?php echo e($permissions->total()); ?> entries
                            </div>
                                
                                <div class="col-md-6">
                                <?php echo e($permissions->links('include.pagination')); ?>

                                </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade edit-layout-modal pr-0 " id="permissionAdd" tabindex="-1" role="dialog" aria-labelledby="permissionAddLabel" aria-hidden="true">
        <div class="modal-dialog w-300" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="categoryAddLabel"><?php echo e(__('Add Permission')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <form class="forms-sample" method="POST" action="<?php echo e(url('permission/create')); ?>">
                    <?php echo csrf_field(); ?>
                  <div class="modal-body">
                    <span id="publicurl" data-value="<?php echo e(url('/')); ?>"></span>
                      <div class="form-group">
                            <label class="d-block">Permission</label>
                            <input type="text" class="form-control" id="permission" name="name" placeholder="Permission Name" required>
                      </div>
                      <div class="form-group">
                          <label for="exampleInputEmail3"><?php echo e(__('Assigned to Role')); ?> </label>
                                <?php echo Form::select('roles[]', $roles, null,[ 'class'=>'form-control select2', 'multiple' => 'multiple']); ?>

                      </div>
                      
                      <div class="form-group">
                          <button type="submit" class="btn btn-primary btn-rounded"><?php echo e(__('Save')); ?></button>
                      </div>
                  </div>
                </form>
            </div>
        </div>
    </div>
    <!-- push external js -->
    <?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('plugins/select2/dist/js/select2.min.js')); ?>"></script>
    <!-- <script src="<?php echo e(asset('plugins/DataTables/datatables.min.js')); ?>"></script>  -->
    <script src="<?php echo e(asset('plugins/DataTables/Cell-edit/dataTables.cellEdit.js')); ?>"></script>
    <!--server side permission table script-->
    <!-- <script src="<?php echo e(asset('js/permission.js')); ?>"></script> -->
    
   <script src="<?php echo e(url('js/global.js')); ?>"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
    <script src = "http://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>
    
<script type="text/javascript">

    var route = "<?php echo e(url('permissionsearch')); ?>";
 $('#search').typeahead({
            source: function (query, process) {
                return $.get(route, {
                    query: query
                }, function (data) {
                    return process(data);
                });
            }
        });
var table = $('#permission_table').DataTable({

        paging: false,
        ordering: true,
        info: false,
        searching:false,
    });

</script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('inventory.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cdapp/trading.cdapp.in/resources/views/permission.blade.php ENDPATH**/ ?>