<?php
namespace App\Http\Controllers;
use App\User;
use Auth;
use DB;
use App\Models\Order;
use App\Models\Client;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index() {

        $orders = Order::with('clientdetail')->paginate(10);
        return view('order.index',compact('orders'));
    }

    public function indexorder($id){
        //return $id;
        $clientid=$id;
        $orders = Order::where('clientId',$id)->paginate(10);
        return view('order.index',compact('orders','clientid'));
    }

    public function createorder($id){
       // return $id;
        $clientid=$id;
        return view('order.create',compact('clientid'));
    }

    /*public function create()
    {
       $clients= Client::select('id','name')->get();
        return view('order.create',compact('clients'));
    }*/

    /**
     * Get single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     */

    

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request ) {
        //return $request;
            /*if(isset($request->file))
            {

                $image = $request->file('file');
                $fileInfo = $image->getClientOriginalName();
                $uniqueId= time().mt_rand();

                $filename = $uniqueId;
                $extension = pathinfo($fileInfo, PATHINFO_EXTENSION);
                $file_name= $filename.'.'.$extension;
                $image->move('images\upload\client/',$file_name);
                $request['uploadfile']= $file_name;
            }*/
            //return $request;
           $client= Order::create($request->except('_token','file'));
            $clientid =$request->clientId;
            return redirect()->route('indexorder',$clientid);
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $clients= Client::select('id','name')->get();
        $order= Order::where('id',$id)->first();
        return view('order.edit',compact('order','clients'));

    }

        /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */

    public function update(Request $request,$id ) {

    //return $request;
        $order= Order::where('id',$id)->update($request->except('_token','_method','file'));
        return redirect()->route('order.index');
    }


    public function orderdelete($id){
        try{
        //return $id;
            $order = Order::where('id',$id)->delete();
            return \Response::json(["status" => "success", "message" => "order delete"]);
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }
    }

    /**
     * Destroy single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy($id) {
       
        
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    
}
