<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\MediaType;
use App\Models\Pack;
use App\Models\DocumentType;

class PacksController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->search!=''){
             $packs=Pack::where('title','like', '%'.$request->search.'%')->with('documentdetail','mediadetail')->paginate(10);
        }
        else{
            $packs=Pack::with('documentdetail','mediadetail')->orderBy('created_at','DESC')->paginate(10);
        }
        return view('packs.index',compact('packs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $mediaType=MediaType::get();
        $documentype=DocumentType::get();
        return view('packs.create',compact('mediaType','documentype'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return $request;
        if(isset($request->file))
            {

                $image = $request->file('file');
                $fileInfo = $image->getClientOriginalName();
                $uniqueId= time().mt_rand();

                $filename = $uniqueId;
                $extension = pathinfo($fileInfo, PATHINFO_EXTENSION);
                $file_name= $filename.'.'.$extension;
                $image->move('images\upload\media/',$file_name);
                $request['uploadfile']= $file_name;
            }
            //return $request;
        Pack::create($request->except('_token'));
        return redirect()->route('medialibrary.index');
    }

    public function mediadetail($id)
    {
        //return $id;
        $pack =Pack::where('id',$id)->with('documentdetail','mediadetail')->first();
         
         return \Response::json(['status'=>"success", 'message'=>'pack show  successfully.', 'pack'=>$pack]);
    }


    public function mediasearch(Request $request){
        //return $request;
        if($request->get('query')!=''){
            $query = $request->get('query');
            //$query=ucfirst($request->query);
        $pack=Pack::where('title','like', '%'.$query.'%')->select('title as name','id')->get(); 
        }
       return response()->json($pack);
    }

    
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $pack=Pack::where('id',$id)->first();
        $mediatype=MediaType::get();
        $documentype=DocumentType::get();
        return view('packs.edit',compact('pack','mediatype','documentype'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //return $request;
        if(isset($request->file))
            {

                $image = $request->file('file');
                $fileInfo = $image->getClientOriginalName();
                $uniqueId= time().mt_rand();

                $filename = $uniqueId;
                $extension = pathinfo($fileInfo, PATHINFO_EXTENSION);
                $file_name= $filename.'.'.$extension;
                $image->move('images\upload\media/',$file_name);
                $request['uploadfile']= $file_name;
            }

        $pack=Pack::where('id',$id)->update($request->except('_token','_method','file'));
        return redirect()->route('medialibrary.index');
    }

    public function librarydelete(Request $request,$id){

        try{

            $pack = Pack::where('id',$id)->delete();
            return \Response::json(["status" => "success", "message" => "Pack delete"]);
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
