<?php

namespace App\Http\Controllers;
use App\User;
use Auth;
use DB;
use App\Models\Routing;
use App\Models\Stage;
use App\Models\Step;
use App\Models\Form;
use Illuminate\Http\Request;

class RoutingController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index() {
        $stages=Stage::paginate(10);
        $routings=Routing::paginate(10);
        return view('routing.index',compact('routings','stages'));
    }


    public function create()
    {
        return view('routing.create');
    }

    /**
     * Get single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     */

    public function store(Request $request ) {
        //return $request;
        $routing=Routing::create($request->except('_token'));
        return redirect()->route('routing.index');
    }


    public function edit($id){
        $routing=Routing::where('id',$id)->first();
        return view('routing.edit',compact('routing'));
    }
    public function show($id) {

        
    }

    /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update( Request $request, $id ) {
        //return $request;
        $stage=Routing::where('id',$id)->update($request->except('_token','_method'));
        return redirect()->route('routing.index');

    }

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */


    /**
     * Destroy single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy( $id ) {
       
        
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    
}
