<?php

namespace App\Http\Controllers;
use App\User;
use Auth;
use DB;
use App\Models\Stage;
use App\Models\Step;
use App\Models\Form;
use Illuminate\Http\Request;

class StageController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index() {
        $stages=Stage::paginate(10);
        $forms=Form::paginate(10);
        return view('stage.index',compact('forms','stages'));
    }

    public function indexstage($id){
        //return $id;
        $routingid=$id;
        $stages=Stage::paginate(10);
        $forms=Form::paginate(10);
        return view('stage.index',compact('forms','stages','routingid'));
    }


    public function createstage($id)
    {
        $routingid=$id;
        return view('stage.create',compact('routingid'));
    }

    public function create()
    {
        return view('stage.create');
    }

    /**
     * Get single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     */

    public function store(Request $request ) {
        //return $request;

        $stage=Stage::create($request->except('_token'));
         $orderid=$request->orderId;
        return redirect()->route('indexstage',$orderid);
    }


    public function edit($id){
        $stage=Stage::where('id',$id)->first();
        return view('stage.edit',compact('stage'));
    }
    
    public function show($id) {

        
    }

    /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update( Request $request, $id ) {
        //return $request;
        $stage=Stage::where('id',$id)->update($request->except('_token','_method'));
        $orderid=$request->orderId;
        return redirect()->route('indexstage',$orderid);

    }

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */


    /**
     * Destroy single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy( $id ) {
       
        
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    
}
