<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Checklist;
use App\Models\UserChecklisttransaction;
use App\Models\Post;
use App\Models\User;
use App\Models\ChecklistDetail;
use App\Models\UserPost;
use Carbon;
use DB;
use App\Models\ChecklistForm;

class UserChecklistController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //return 'test';
        $user_id=auth()->guard("user")->id();
       $users=UserPost::where('user_id',$user_id)->with('postdetail')->select('id','post_id')->groupBy('post_id')->get();

        //$post=Post::where('')
         $post_id=[];
         $checklists=[];
         $checklistsid=[];
        foreach($users as $user){
          //array_push($post_id, $user->post_id
          $checklists[]= Checklist::where('post_id',$user->post_id)->with('postdetail','checklistcount')->orderBy('created_at','DESC')->groupBy('id')->paginate(10);        
        }
        //return $post_id;
        
        //return $checklists;

        foreach($checklists as $checklist){
             //return $checklist;
            foreach($checklist as $list){
              // return $list;
            array_push($checklistsid,$list->id);
            }
        }

        //return $checklistsid;

        $user=UserChecklisttransaction::where('user_id',$user_id)->first();
        //if(isset($user)){
        $userdata= explode('<br>', $user->checklist_item_details);
        $userdata1= implode(',', $userdata);
        $userdata2= explode(',', $userdata1);

        $userdata3=[];
         foreach( $userdata2 as $data){
           // return $data;
             $userdata3[]= explode('|', $data);
         }

         //return $userdata3;

         $useridvalue=[];
         $userdatevalue=[];
                                        
        foreach($userdata3 as $key=>$user){
        //$user123=$user[0];     
        array_push($useridvalue, $user[0]);
        array_push($userdatevalue, $user[3]);                                                                    
        }

        //return $useridvalue;
        $newval= DB::table('checklist_details')->select(DB::raw('count(id) as total'),'checklist_details.id_checklist')->whereIN('id',$useridvalue)->groupBy('id_checklist')->get();
         return view('user.userchecklist.index',compact('checklists','users','newval','checklistsid','useridvalue','user_id'));
    //}
    /*else{
         return view('user.userchecklist.index',compact('checklists','users'));
    }*/
    //return $checklists;
       

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    public function assignform($id){
       // return $id;
    $forms=ChecklistForm::where('user_id',$id)->with('formdetail')->first(); 
      return view('user.userchecklist.form',compact('forms'));
    }

    public function updateuserform(Request $request,$id){
        //return $request;
       // return $id;
        ChecklistForm::where('user_id',$id)->where('form_id',$request->id)->update(['formsfield'=>$request->formfield]);
        return redirect()->back();
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request,$id)
    {
        //return $id;
        //return $request;
        $user_id=auth()->guard("user")->id();
        if($request->search!=''){
            $search=$request->search;
            //$checklists=ChecklistDetail::with('listdetail')->where('title','like', '%'.$request->search.'%')->first();
            $checklists=Checklist::where('id',$id)->with('checklistdetail','postdetail')->whereHas('checklistdetail',  function($q) use ($search){
                    $q->where('title','like', $search);
                })->first();
        }
        else{
        //return $id;
          $checklists=Checklist::where('id',$id)->with('checklistdetail','postdetail')->first();
        }
        $user=UserChecklisttransaction::where('user_id',$user_id)->first();
         //return $userdata2= explode('|', $user->checklist_item_details);
        if(isset($user)){
        $userdata= explode('<br>', $user->checklist_item_details);
        $userdata1= implode(',', $userdata);
        $userdata2= explode(',', $userdata1);

        $userdata3=[];
         foreach( $userdata2 as $data){
           // return $data;
             $userdata3[]= explode('|', $data);
         }

         $useridvalue=[];
         $userdatevalue=[];
                                        
        foreach($userdata3 as $key=>$user){
        //$user123=$user[0];     
        array_push($useridvalue, $user[0]);
        array_push($userdatevalue, $user[3]);                                                                    
        }
        //return $userdata3;
        //return $user123;
        }
         return view('user.userchecklist.checklistdetail',compact('checklists','userdata3','useridvalue','userdatevalue'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //return $id;
        $checklist= Checklist::with('mediadetail')->find($id);
        //$checklist= ChecklistDetail::where('id',$id)->with('mediadetail')->first();
        return view('user.userchecklist.edit',compact('checklist'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function storedate(Request $request){
        //return $request;
        $user_id=auth()->guard("user")->id();
        $check['user_id']=auth()->guard("user")->id();
        //$checklist=Checklist::where('id',$request['checklist_id'])->select('title')->first();
        $user=UserChecklisttransaction::where('user_id',$user_id)->first();

        $request['date_completed'] =  date('Y-m-d');
        if($user !=''){
            //return 'if';
            $check['checklist_item_details']= $user['checklist_item_details']. '<br>'.($request['id'].'|'.$request['title'].'|'.$request['date_completed'].'|'.$request['entry_date']);
            //$check['completed']=$request['completed'];
            $check['entry_date']=$request['entry_date'];
            //$check['checklist_id']=$request['checklist_id'];
            $user=UserChecklisttransaction::where('user_id',$user_id)->update($check);
        }

        else{
           // return 'else';
            $check['checklist_item_details']=$request['id'].'|'.$request['title'].'|'.$request['date_completed'].'|'.$request['entry_date'];
            //$check['completed']=$request['completed'];
            $check['entry_date']=$request['entry_date'];
            //$check['checklist_id']=$request['checklist_id'];
            $user=UserChecklisttransaction::create($check); 
        }
         return \Response::json(['status'=>"success", 'message'=>'list submitted successfully.']);
        //return redirect()->route('userchecklist.index');
    }
    public function update(Request $request, $id)
    {
        //return $request;
        $user_id=auth()->guard("user")->id();
        $check['user_id']=auth()->guard("user")->id();
        $checklist=Checklist::where('id',$request['checklist_id'])->select('title')->first();
        $user=UserChecklisttransaction::where('user_id',$user_id)->first();

        if($user !=''){

            $check['checklist_item_details']= $user['checklist_item_details']. '<br>'.($request['checklist_detail_id'].'|'.$checklist['title'].'|'.$request['date_completed']);
            $check['completed']=$request['completed'];
            $check['date_completed']=$request['date_completed'];
            $check['checklist_id']=$request['checklist_id'];
            $user=UserChecklisttransaction::where('user_id',$user_id)->update($check);
        }

        else{

            $check['checklist_item_details']=$request['checklist_detail_id'].'|'.$request['title'].'|'.$request['date_completed'];
            $check['completed']=$request['completed'];
            $check['date_completed']=$request['date_completed'];
            $check['checklist_id']=$request['checklist_id'];
            $user=UserChecklisttransaction::create($check); 
        }
        
        return \Response::json(['status'=>"success", 'message'=>'list submitted successfully.']);


    }

    public function viewchecklist($id){

        $list =ChecklistDetail::where('id',$id)->with('mediadetail')->first();
         
         return \Response::json(['status'=>"success", 'message'=>'list show successfully.', 'list'=>$list]);
    }

    public function search(Request $request){
        //return $request;
        if($request->get('query')!=''){
            $query = $request->get('query');
           
        $list=ChecklistDetail::where('title','like', '%'.$query.'%')->select('title as name','id')->get(); 
        }
       return response()->json($list);
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
