<?php

namespace App\Http\Controllers;
use App\User;
use Auth;
use DB;
use App\aFormMaster;
use App\Http\Requests\aFormMasterStoreRequest;
use Illuminate\Http\Request;

class aFormMasterController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index() {
 if(isset($_REQUEST['filterType'])){
            $filterType = $_REQUEST['filterType'];
          }else{
              $filterType = false;
          }

		   if (isset($filterType)) {
            $aformmaster = aFormMaster::where('stepId', '=', '' . $filterType . '')->with('ctype')->get();
          }
        else
        {
            $aformmaster = aFormMaster::with('ctype')->get();      
        }
                
        
        

        return response()->json([
            'data' => $aformmaster
        ]);
    }

    /**
     * Get single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show( aFormMaster $aformmaster ) {

        return response()->json([
            'data' => $aformmaster
        ]);
    }

    /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update( aFormMasterStoreRequest $request, aFormMaster $aformmaster ) {
        $aformmaster->fill($request->all());
		//User Information Details Submit
        $aformmaster->save();
        return response()->json([
            'status' => true,
            'data' => $aformmaster
        ]);
    }

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store( aFormMasterStoreRequest $request ) {
        $aformmaster = new aFormMaster;
        $aformmaster->fill($request->all());
        //User Id Generate Dynamically.
        $year = date("Y");
        $year = substr( $year, -2);
        $month = date("m");
        //Fetch last company id from CompanyMaster
        $lastaformid=DB::table('assignforms')
       ->select('assignforms.aformId')->OrderBy('assignforms.aformId', 'DESC')->first();
        if($lastaformid==NULL){
           
            $bId = "1";
		}
		else{
            $lastaformid = $lastaformid->aformId;
            $lastaformid = substr( $lastaformid, -6);
            $sequence = $lastaformid + 1;
            $bId = $sequence;
		}
       
        //User Information Details Submit
        $aformmaster->aformId = $bId;
		$aformmaster->stepId = $_REQUEST['filterType'];
        $aformmaster->save();

        return response()->json([
            'status' => true,
            'created' => true,
            'data' => [
                'id' => $bId
            ]
        ]);
    }

    /**
     * Destroy single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy( aFormMaster $aformmaster ) {
       
       // $companymaster->delete();
        //echo "amar";
        return response()->json([
            'status' => true
        ]);
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroyMass( Request $request ) {
        $request->validate([
            'ids' => 'required|array'
        ]);

        aFormMaster::destroy($request->ids);

        return response()->json([
            'status' => true
        ]);
    }
}
