<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Checklist extends Model
{
    use HasFactory;
    protected $fillable = [
        'title', 'description','post_id'
    ];

    public function listdetail(){
        return $this->belongsTo('App\Models\UserChecklisttransaction','id','checklist_id');
    }

    public function mediadetail(){
        return $this->belongsTo('App\Models\Pack','medialibrary_id');
    }

    public function checklistdetail(){
        return $this->hasmany('App\Models\ChecklistDetail','id_checklist')->orderBy('display_sequence','ASC');
    }

    public function postdetail(){
        return $this->belongsTo('App\Models\Post','post_id');
    }

    public function checklistcount(){
        return $this->belongsTo('App\Models\ChecklistCount','id','id_checklist');
    }

    /*public function countchecklist(){
        return $this->hasmany('App\Models\ChecklistDetail','id_checklist','id')->count();
    }*/
}
