@extends('inventory.layout') 
@section('title', 'Forms')
@section('content')
 @push('head')
  
  <style>
    .error{
      color: red;
    }
    /*.searchclass{
        text-transform:capitalize;
    }*/
    .tradeadd{
        background-color: #2dce89;
        border-color: #2dce89;
        color:#fff !important;
    }
    .tradeadd:hover{
    background-color:#2dce89;
    border-color: #2dce89;
    }
    .showmedia{
        padding-right: 10px;
    }


  </style>
  @endpush
    <!-- push external head elements to head --> 
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <!-- <i class="ik ik-users bg-green"></i> -->
                        <div class="d-inline">
                            <h5>Forms</h5>
                            <span>View, delete and update forms</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">Forms</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <div class="row">
            <!-- list layout 1 start -->
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header row">
                       
                        <div class="col col-sm-6">
                            <div class="card-search with-adv-search dropdown">
                                <form action="" method="get">
                                    <input type="text" class="form-control global_filter searchclass" id="search" name="search" placeholder="Search.." >
                                    <button type="submit" class="btn btn-icon"><i class="ik ik-search"></i></button>
                                    <button type="button" id="adv_wrap_toggler_1" class="adv-btn ik ik-chevron-down dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></button>
                                    
                                </form>
                            </div>
                        </div>
                        <div class="col col-sm-5">
                            <div class="card-options text-right">
                                <span class="mr-5" id="top">entries</span>
                                <a href="#"><i class="ik ik-chevron-left"></i></a>
                                <a href="#"><i class="ik ik-chevron-right"></i></a>
                                <a href="{{route('forms.create')}}" class=" btn btn-outline-primary btn-semi-rounded tradeadd"><i class="ik ik-plus"></i>&nbsp;Create Form</a>
                            </div>
                           
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="product_table" class="table">
                            <thead>
                                <tr>
                                    
                                    <th>{{ __('Title')}}</th>
                                    <th>{{ __('Description')}}</th>
                                    <th style="width: 100px;!important">{{ __('Action')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($forms as $form)
                                <tr>
                                     
                                        <td>{{ isset($form->title) ? $form->title :'' }}</td>

                                        <td>{{ \Illuminate\Support\Str::limit($form->description, 70) }}</td> 
                                    
                                    <td> 

                                        <a href="{{route('forms.edit', $form->id) }}"  ><i class="ik ik-edit-2  text-green"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                                        <a href="javascript:;" class="deletebyformid" data-id="{{ isset($form->id) ? $form->id:'' }}"  data-url="{{route('formdelete',$form['id'])}}"><i class="ik ik-trash-2 f-16 text-red"></i></a>
                                        
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                        <div class="card-footer d-flex align-items-center">

                                <div class="col-md-6">
                                </div>
                                
                                <div class="col-md-6">
                                {{ $forms->links('include.pagination') }}
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- list layout 1 end -->
            <div class="col-md-12"><hr></div>
            <!-- list layout 2 -->
            
            <!-- list layout 2 end -->
        </div>
    </div>
    
    <!-- category add modal-->


@push('script')
<script src="{{ url('js/global.js')}}"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
<script src = "http://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>

<script type="text/javascript">
    
</script>
 @endpush
 @endsection