@extends('inventory.layout') 
@section('title', 'Edit Order')
@section('content')
    <!-- push external head elements to head -->
    @push('head')
        <link rel="stylesheet" href="{{ asset('plugins/select2/dist/css/select2.min.css') }}">
       <link rel="stylesheet" href="{{ asset('plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css') }}">
         <link rel="stylesheet" href="{{ asset('plugins/mohithg-switchery/dist/switchery.min.css') }}">
        <style type="text/css">
            .gsterror{
                color: red;
            }
            .emailerror{
                color: red;
            }
            .gstverify{
                color: #4b9732;
            }
            .protable{
                overflow-x: auto;
            }
        </style>
    @endpush

    
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <!-- <i class="ik ik-user-plus bg-blue"></i> -->
                        <div class="d-inline">
                            <h5>Order</h5>
                            <span>{{ __('Edit order')}}</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">{{ __('Edit Order')}}</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
       <form class="forms-sample" method="POST" action="{{ route('order.update',$order->id) }}" id="regForm" enctype= multipart/form-data>
        @csrf
        @Method('PUT')
        @include('include.message')

            <div class="row">
                <!-- start message area-->
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-header">
                            <strong><h3>{{ __('Basic Information')}}</h3></strong>
                        </div>
                        <div class="card-body">
                            
                    <div class="row">  
                        {{--<div class="col-sm-6">  
                            <div class="form-group">
                            <label for="name">{{ __('Select Client')}}<span class="text-red">*</span></label>
                                <select  class="form-control " name="clientId" id="client">
                                    <option value="">Please Select</option>
                                    @foreach($clients as $client)
                                        @if($client->id==$order->clientId)
                                            <option value="{{$client->id}}" selected="true">{{isset($client->name) ? $client->name:''}}</option>
                                        @else
                                            <option value="{{$client->id}}">{{isset($client->name) ? $client->name:''}}</option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>
                        </div>--}}
                        <div class="col-sm-6"> 
                            <div class="form-group">
                                <label for="name">{{ __('Routing Form')}}</label>
                                <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="routingformId" value="{{isset($order->routingformId) ? $order->routingformId :''}}" placeholder="Enter Routing Form">
                           </div>     
                        </div>

                        <div class="col-sm-6"> 
                            <div class="form-group">
                                <label for="name">{{ __('Customer Name')}}<span class="text-red">*</span></label>
                                <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="customerName" value="{{isset($order->customerName) ? $order->customerName :''}}" placeholder="Enter Name" required>
                           </div>     
                        </div>
                        <div class="col-sm-6">  
                            <div class="form-group">
                                <label for="company">{{ __('Contact Person')}}<span class="text-red">*</span></label>
                                <input id="company" type="text" class="form-control" name="contactPerson" value="{{isset($order->contactPerson) ? $order->contactPerson :''}}" placeholder="Enter Contact Person" required>
                            </div>   
                        </div>  

                        <div class="col-sm-6">  
                            <div class="form-group">
                                <label for="company">{{ __('Contact Number')}}<span class="text-red">*</span></label>
                                <input id="company" type="text" class="form-control" name="contactNumber" value="{{isset($order->contactNumber) ? $order->contactNumber :''}}" placeholder="Enter Contact Number" required>
                            </div>   
                        </div>

                        <div class="col-sm-6">  
                            <div class="form-group">
                                <label for="company">{{ __('Address')}}<span class="text-red">*</span></label>
                                <textarea class="form-control description" name="Address" rows="2">{{isset($order->Address) ? $order->Address :''}}</textarea>
                            </div>   
                        </div>

                        <div class="col-sm-6">  
                            <div class="form-group">
                                <label for="state">{{ __('State')}}<span class="text-red">*</span></label>
                                <select  class="form-control " name="state" id="state">
                                    <option value="">Please Select</option>
                                    @if($order->state=='10' || $order->state=='20' )
                                        <option value="10" @if ($order->state == '10') {{ 'selected' }} @endif>Maharashtra</option>
                                        <option value="20" @if ($order->state == '20') {{ 'selected' }} @endif>Delhi</option>
                                    @else
                                        <option value="10">Maharashtra</option>
                                        <option value="20">Delhi</option>
                                    @endif

                                </select>                                   
                            </div>   
                        </div>
                                    

                        <div class="col-sm-6">  
                            <div class="form-group">
                                <label for="city">{{ __('City')}}<span class="text-red">*</span></label>
                                <select  class="form-control " name="city" id="city">
                                    <option value="">Please Select</option>
                                    @if($order->city=='101' || $order->city=='201' )
                                        <option value="101"  @if ($order->city == '101') {{ 'selected' }} @endif>Pune</option>
                                        <option value="201"  @if ($order->city == '201') {{ 'selected' }} @endif>Mumbai</option>
                                    @else
                                        <option value="101">Pune</option>
                                        <option value="201">Mumbai</option>
                                    @endif
                                </select>
                                
                               
                            </div>
                        </div>
                                <div class="col-sm-6">  
                                    <div class="form-group">
                                        <label for="company">{{ __('Zipcode')}}<span class="text-red">*</span></label>
                                        <input id="zip" type="text" class="form-control" name="zip" value="{{isset($order->zip) ? $order->zip :''}}" placeholder="Enter Zipcode" required>
                                    </div>   
                                    </div>   

                                     <div class="col-sm-6">  
                                    <div class="form-group">
                                        <label for="whatsappLocation">{{ __('Whatsapp Location')}}<span class="text-red">*</span></label>
                                        <input id="whatsapp" type="text" class="form-control" name="whatsappLocation" value="{{isset($order->whatsappLocation) ? $order->whatsappLocation :''}}" placeholder="Enter Whatsapp Location" required>
                                    </div>   
                                    </div>                         
                    
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- start message area-->
                
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-body">
                            <div class="col-md-12" style="text-align: center;">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">{{ __('Update')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <!-- push external js -->
    @push('script') 
    
    <script src="{{ asset('plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js') }}"></script>
        <script src="{{ asset('plugins/jquery.repeater/jquery.repeater.min.js') }}"></script>
    <script src="{{ asset('plugins/mohithg-switchery/dist/switchery.min.js') }}"></script>
    <script src="{{ asset('js/form-advanced.js') }}"></script>
    
 

     
    @endpush
@endsection
