@extends('inventory.layout') 
@section('title', 'Edit Routing Step')
@section('content')
    <!-- push external head elements to head -->
    @push('head')
        <link rel="stylesheet" href="{{ asset('plugins/select2/dist/css/select2.min.css') }}">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.css">
        <style type="text/css">
            .gsterror{
                color: red;
            }
            .emailerror{
                color: red;
            }
            .gstverify{
                color: #4b9732;
            }
            .protable{
                overflow-x: auto;
            }
        </style>
    @endpush

    
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <!-- <i class="ik ik-user-plus bg-blue"></i> -->
                        <div class="d-inline">
                            <h5>{{ __('Edit Routing Step')}}</h5>
                            <span>{{ __('Edit Routing Step')}}</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">{{ __('Edit Routing Step')}}</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <form class="forms-sample" method="POST" action="{{ route('steps.update',$step->id) }}" enctype= multipart/form-data id="Postform">
        @csrf
        @Method('PUT')
        @include('include.message')

            <div class="row">
                <!-- start message area-->
                
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-header">
                            <strong><h3>{{ __('Basic Information')}}</h3></strong>
                        </div>
                        <div class="card-body">
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name">{{ __('User')}}<span class="text-red">*</span></label>
                                        <select  class="form-control select2" name="user_id[]" id="user" multiple="multiple" required="">
                                            <option value="">Please Select</option>
                                            @foreach($users as $user)
                                                @if($user->id==$step->userGroup)
                                                    <option value="{{$user->id}}" selected="true">{{isset($user->name) ? $user->name:''}}</option>
                                                @else
                                                    <option value="{{$user->id}}">{{$user->name}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <input type="hidden" name="stageId" value="{{isset($step->stageId) ? $step->stageId:''}}">
                                <div class="col-sm-6">    
                                    <div class="form-group">
                                        <label for="post_name">Step Name<span class="text-red">*</span></label>
                                        <input id="post_name" type="text" class="form-control" name="stepName" value="{{isset( $step->stepName) ?  $step->stepName:''}}" placeholder="Enter step Name" required="">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="purpose">Description</label>
                                        <textarea name="description" class="form-control" rows="2" >{{isset( $step->description) ?  $step->description:''}}</textarea>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="knowhow">Label</label>
                                        <input id="label1" type="text" class="form-control" name="label1" value="{{isset( $step->label1) ?  $step->label1:''}}" placeholder="Enter label" >
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="duties">Value</label>
                                         <!-- <input id="val" type="checkbox" class="form-control" name="value1"> -->
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="knowhow">Label</label>
                                        <input id="label2" type="text" class="form-control" name="label2" value="{{isset($step->label2) ? $step->label2 :''}}" placeholder="Enter label" >
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="duties">Value</label>
                                        <!--  <input id="val" type="checkbox" class="form-control" name="value2" > -->
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="duties">Status</label>
                                          <select  class="form-control " name="status" id="status">
                                            <option value="">Please Select</option>
                                            @if($step->status=='InProcess' ||$step->status =='completed')
                                            
                                                <option value="InProcess"  {{ ($step->status) == 'InProcess' ? 'selected' : '' }}>In Process</option>
                                                <option value="completed"  {{ ($step->status) == 'completed' ? 'selected' : '' }}>Completed</option>
                                            @else
                                                <option value="InProcess">In Process</option>
                                                <option value="completed">Completed</option>
                                            @endif
                                        </select>
                                    </div>
                                </div>
                            </div>  
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- start message area-->
                
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-body">
                            <div class="col-md-12" style="text-align: center;">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">{{ __('Update')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <!-- push external js -->
    @push('script') 
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
    <script type="text/javascript">

    var route = "{{ url('searchclient') }}";
    $('#client_name').typeahead({
            source: function (query, process) {
                return $.get(route, {
                    query: query
                }, function (data) {
                    console.log(data);
                    return process(data);
                });
            }
        });
    
    </script>


    <script type="text/javascript">
        $(function () {
        $('#dropify').dropify();
        });
/*state and city*/
         $('#tradestate').on('change', function() {
            //alert('xdvgdfgdf');
            var state_id = this.value;
            console.log(state_id);
            var url=$(this).data('url');
            console.log(url);
             $("#tradecity").html('');
            $.ajax({
                url:url,
                type: "GET",
                data: {
                    state_id: state_id
                },
                dataType : 'json',
                success: function(result){
                    console.log(result);
                    $.each(result.city,function(key,value){
                    $("#tradecity").append('<option value="'+value.id+'">'+value.name+'</option>');
                    });
                }
            });
        
        
    });
/*state and city js */

/*secondary state and city js */
         $('#secondarystate').on('change', function() {
            //alert('xdvgdfgdf');
            var state_id = this.value;
            console.log(state_id);
            var url=$(this).data('url');
            console.log(url);
             $("#secondarycity").html('');
            $.ajax({
                url:url,
                type: "GET",
                data: {
                    state_id: state_id
                },
                dataType : 'json',
                success: function(result){
                    console.log(result);
                    $.each(result.city,function(key,value){
                    $("#secondarycity").append('<option value="'+value.id+'">'+value.name+'</option>');
                    });
                }
            });
        
        
        });
    </script>
    <!-- image -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js"></script>
     
    @endpush
@endsection
