<?php

namespace App\Http\Controllers;
use App\User;
use Auth;
use DB;
use App\Models\Stage;
use App\Models\Step;
use App\Models\Form;
use Illuminate\Http\Request;

class StageController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request) {
        if($request->search!=''){

                $stages=Stage::where('stageName','like', '%'.$request->search.'%')->paginate(10);
            }
        $stages=Stage::paginate(10);
        $forms=Form::paginate(10);
        return view('stage.index',compact('forms','stages'));
    }

    public function indexstage(Request $request,$id){
        //return $id;
        try{

            $routingid=$id;

            if($request->search!=''){

                $stages=Stage::where('stageName','like', '%'.$request->search.'%')->paginate(10);
            }
            else{

                $stages=Stage::paginate(10);
            }
            $forms=Form::paginate(10);
            return view('stage.index',compact('forms','stages','routingid'));
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }
    }


    public function createstage($id)
    {
        $routingid=$id;
        return view('stage.create',compact('routingid'));
    }

    public function create()
    {
        return view('stage.create');
    }

    /**
     * Get single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     */

    public function store(Request $request ) {
        //return $request;

        $stage=Stage::create($request->except('_token'));
         $orderid=$request->orderId;
        return redirect()->route('indexstage',$orderid);
    }


    public function edit($id){
        $stage=Stage::where('id',$id)->first();
        return view('stage.edit',compact('stage'));
    }
    
    public function show($id) {

        
    }

    /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update( Request $request, $id ) {
        //return $request;
        $stage=Stage::where('id',$id)->update($request->except('_token','_method'));
        $orderid=$request->orderId;
        return redirect()->route('indexstage',$orderid);

    }

    public function stagesearch(Request $request){
        //return $request;
        if($request->get('query')!=''){
            $query = $request->get('query');
            //$query=ucfirst($request->query);
        $post=Stage::where('stageName','like', '%'.$query.'%')->select('stageName as name','id')->get(); 
        }
       return response()->json($post);
    }

    public function stagedelete(Request $request, $id)
    {
        //return  $request;
        try{
            $post = Stage::where('id',$id)->delete();
            return \Response::json(["status" => "success", "message" => "Stage delete"]);
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }

    }

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */


    /**
     * Destroy single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy( $id ) {
       
        
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    
}
