<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Tenant;
use App\Models\State;
use App\Models\City;

class TenantController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try{
            if($request->search!=''){
             $tenants=Tenant::where('name','like', '%'.$request->search.'%')->paginate(10);
        }
        else{

            $tenants=Tenant::orderBy('created_at','DESC')->paginate(10);
        }
            return view('tenant.index',compact('tenants'));
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $states= State::get();
        $cities =City::get();
        return view('tenant.create',compact('states','cities'));
    }

    public function getCity(Request $request)
    {
        //return $request;
         $city = City::where('state_id',$request->state_id)->select('id','name')->get();
        return response()->json(['city'=>$city]);
    }


    public function postdetail($id){

        $post =Tenant::where('id',$id)->first();
         
         return \Response::json(['status'=>"success", 'message'=>'post show  successfully.', 'post'=>$post]);
    }

    public function poststatus(Request $request,$id)
    {
       //return $request;
       try{
            //return $id;
            //return $request;
            $tenant = Tenant::where('id',$id)->update(['status'=>$request['stat']]);
           return \Response::json(["status" => "success", "message" => "tenant updated successfully!"]);
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return $request;
        try{

         Tenant::create($request->except('_token'));
         return redirect()->route('tenant.index');

        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }
    }


    public function tenantsearch(Request $request){
        //return $request;
        if($request->get('query')!=''){
            $query = $request->get('query');
            //$query=ucfirst($request->query);
        $tenant=Tenant::where('name','like', '%'.$query.'%')->select('name','id')->get(); 
        }
       return response()->json($tenant);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
        try{
            $tenant = Tenant::where('id',$id)->first();
            return view('posts.edit',compact('post'));
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try{
            $states= State::get();
            $cities =City::get();
            $tenant = Tenant::where('id',$id)->first();
            return view('tenant.edit',compact('tenant','states','cities'));
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
            //return $request;
            $tenant = Tenant::where('id',$id)->update($request->except('_token','_method'));
            return redirect()->route('tenant.index');

        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }
    }

    public function tenantdelete(Request $request, $id)
    {
        //return  $request;
        try{
            $tenant = Tenant::where('id',$id)->delete();
            return \Response::json(["status" => "success", "message" => "Tenant delete"]);
        }catch (Exception $e) {
            return \Response::json(["status" => "danger", "message" => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
