<?php

namespace App\Http\Controllers;

use App\Http\Requests\UserRequest;
use App\Models\User;
use Auth;
use DataTables;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\View\View;
use Spatie\Permission\Models\Role;
use App\Models\Post;
use App\Models\UserPost;
use App\Models\Checklist;
use App\Models\UserChecklisttransaction;
use App\Models\ChecklistDetail;
use DB;

class UserController extends Controller
{

    /**
     * Show the users dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {

        $posts=Post::orderBy('created_at','DESC')->get();
        if($request->search!=''){
            $users= User::where('name','like', '%'.$request->search.'%')->select('id','name','email')->with('roles', 'permissions')->paginate(10); 
        }
        else{
             $users= User::select('id','name','email')->with('roles', 'permissions')->paginate(10);
        }
        //return $userpermission= $users->getAllPermissions();
        //$data= User::with('roles', 'permissions')->get();
         //$userpermission= $data->getAllPermissions();
        $roles = Role::pluck('name', 'id');
        return view('users', compact('roles','users','posts'));
    }

    public function usersearch(Request $request)
    {
        
       //return $request;
        if($request->get('query')!=''){
             $query = $request->get('query');
                $usersearch = User::where('name','like', '%'.$query.'%')->select('id','name')->get();
        }
        return response()->json($usersearch);
    }

    public function profile(){
        //return 'hffgf';
        $userid= auth()->user()->id;
        $user=User::where('id',$userid)->first();
        return view('profile',compact('user'));
    }

    public function updateuser(Request $request){
        //return $request;
        User::where('id',$request->id)->update($request->except('_token'));
        return redirect()->back();
    }

    /**
     * Show User List
     *
     * @param Request $request
     * @return mixed
     */
    public function userpost($id){
        //return $id;
        $user_id=$id;
        $users=UserPost::where('user_id',$id)->with('postdetail')->select('id','post_id')->orderBy('created_at','ASC')->groupBy('post_id')->get();
         //return count( $users);
         $checklists=[];
        foreach($users as $user){
         $checklists[]= Checklist::where('post_id',$user->post_id)->with('checklistdetail','postdetail','checklistcount')->orderBy('created_at','DESC')->groupBy('id')->paginate(10);
        }

            // return $checklists;


        $checklistsid=[];
        $listss=[];
        foreach($checklists as $checklist){
             // $checklist;
            foreach($checklist as $list){
              // return $list;
                $listss[]=$list;
            array_push($checklistsid,$list->id);
            }
        }
        //return $listss;
        //return  $checklists;
        $user=UserChecklisttransaction::where('user_id',$user_id)->first();
        if(isset($user)){
        $userdata= explode('<br>', $user->checklist_item_details);
        $userdata1= implode(',', $userdata);
        $userdata2= explode(',', $userdata1);

        $userdata3=[];
         foreach( $userdata2 as $data){
           // return $data;
             $userdata3[]= explode('|', $data);
         }

         //return $userdata3;

         $useridvalue=[];
         $userdatevalue=[];
                                        
        foreach($userdata3 as $key=>$user){
        //$user123=$user[0];     
        array_push($useridvalue, $user[0]);
        array_push($userdatevalue, $user[3]);                                                                    
        }
        //return $userdatevalue;
        $newval= DB::table('checklist_details')->select(DB::raw('count(id) as total'),'checklist_details.id_checklist')->whereIN('id',$useridvalue)->groupBy('id_checklist')->get();

         //return $newval= ChecklistDetail::whereIN('id',$useridvalue)->select('id','id_checklist')->groupBy('id_checklist')->get();
        //return $useridvalue;
        //$countval=[];
            //foreach($users as $user){
            //foreach($useridvalue as $j=>$userid){

               // $countval[]= 


               // return $user;
            /*foreach($checklists as $Key=>$checklist){

            foreach($checklist as $i=>$lists){
              // return $lists;
                foreach($lists->checklistdetail as $detail){*/
                    //foreach($newval as $val){
                        //return $val->id;
            // return $detail;
               //return $lists;
            //return $lists->checklistcount->checklist_detail_id;
                //return $detail;
                    //return $user[0];
                   //if($user->post_id == $lists->post_id){
                    //return $lists->post_id ;
                    //if(isset($detail->id)){
                    //$countval[]=  Checklist::where('id',$val->id_checklist)->groupBy('post_id')->get();
                //}
                   // }          
                /*}
            }
            
            }
            }*/
            //}
        //}
        /*return $countval;
         $ven= implode(',',$countval);
         //return $vendorid = explode(',', $ven);
           
        foreach($countval as $key=>$val){
            
            //return $key."=>".$val."\n";
        }*/
        //return count($useridvalue);

        //return $useridvalue;
        //return $user123;
         //return $checklists;
        return view('userpost',compact('users','checklists','user_id','useridvalue','newval','checklistsid','listss'));
      }else{
         return view('userpost',compact('users','checklists','user_id','listss'));
      }

    } 

    public function show(Request $request,$id,$user_id){
        //return $id;
        //return $user_id;
        $checklists=Checklist::where('id',$id)->with('checklistdetail','postdetail')->first();

        $user=UserChecklisttransaction::where('user_id',$user_id)->first();
        if(isset($user)){
        $userdata= explode('<br>', $user->checklist_item_details);
        $userdata1= implode(',', $userdata);
        $userdata2= explode(',', $userdata1);

        $userdata3=[];
         foreach( $userdata2 as $data){
           // return $data;
             $userdata3[]= explode('|', $data);
         }
        return view('userchecklist',compact('checklists','userdata3'));
        }else{
           return view('userchecklist',compact('checklists')); 
        }
    }
    public function getUserList(Request $request)
    {
        //return $request;
        $data = User::get();
        $hasManageUser = Auth::user()->can('manage_user');

        return Datatables::of($data)
            ->addColumn('roles', function ($data) {
                $roles = $data->getRoleNames()->toArray();
                $badge = '';
                if ($roles) {
                    $badge = implode(' , ', $roles);
                }

                return $badge;
            })
            ->addColumn('permissions', function ($data) {
                $roles = $data->getAllPermissions();
                $badges = '';
                foreach ($roles as $key => $role) {
                    $badges .= '<span class="badge badge-dark m-1">' . $role->name . '</span>';
                }

                return $badges;
            })
            ->addColumn('action', function ($data) use ($hasManageUser) {
                $output = '';
                if ($data->name == 'Super Admin') {
                    return '';
                }
                if ($hasManageUser) {
                    $output = '<div class="table-actions">
                                <a href="javascript:;"  class="edituserid"  data-id="'. $data->id .'" data-url="'. url('user/' . $data->id) . '"><i class="ik ik-edit-2 f-16 mr-15 text-green"></i></a>
                                
                                <a href="' . url('user/delete/' . $data->id) . '"  ><i class="ik ik-trash-2 f-16 text-red"></i></a>
                            </div>';
                }

                return $output;
            })
            ->rawColumns(['roles', 'permissions', 'action'])
            ->make(true);
    }

    /**
     * User Create
     *
     * @return mixed
     */
    public function create()
    {
        try {
            $roles = Role::pluck('name', 'id');

            return view('create-user', compact('roles'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    /**
     * Store User
     *
     * @param UserRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(UserRequest $request)
    {
        try {
            //return $request;
           // return count($request['post_id']);
            // store user information
            $user = User::create([
                'name' => $request->name,
                'email' => $request->email,
                'password' => $request->password,
                'mobile'=> $request->mobile,
                'joining_date'=>$request->joining_date,

                
            ]);


            for($i = 0; $i< count($request['post_id']); $i++){

                $post['user_id'] = $user->id;
                $post['post_id'] = $request['post_id'][$i];
                UserPost::create($post);
            }



            if ($user) {
                // assign new role to the user
                $user->syncRoles($request->role);

                return redirect('users')->with('success', 'New user created!');
            }

            return redirect('users')->with('error', 'Failed to create new user! Try again.');
        } catch (\Exception $e) {
            $bug = $e->getMessage();

            return redirect()->back()->with('error', $bug);
        }
    }

    /**
     * Edit User
     *
     * @param int $id
     * @return mixed
     */
    public function edit($id)
    {
        try {
            $posts=Post::orderBy('created_at','DESC')->get();
            $user = User::with('roles', 'permissions','postdetail','userpost')->find($id);

            $selected_post = [];
            foreach ($user->userpost as $post_tag) {
                //return $post_tag->post_id;
                array_push($selected_post, $post_tag->post_id);
           
            }
            //return $selected_post;

             $userpermission= $user->getAllPermissions();

            if ($user) {
                $user_role = $user->roles->first();
                $roles = Role::pluck('name', 'id');

                
                 return \Response::json(['status'=>"success", 'message'=>'role edit successfully.','user'=>$user, 'role'=>$roles,'user_role'=>$user_role,'userpermission'=>$userpermission,'posts'=>$posts,'selected_post'=>$selected_post]);
            }

            return redirect('404');
        } catch (\Exception $e) {
            $bug = $e->getMessage();

            return redirect()->back()->with('error', $bug);
        }
    }

    /**
     * Update User
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request)
    {
        //return $request;
        //return count($request['post_id']);
        
        // update user info
        /*$validator = Validator::make($request->all(), [
            'id' => 'required',
            'name' => 'required | string ',
            'email' => 'required | email',
            'role' => 'required',
        ]);

        // check validation for password match
        if (isset($request->password)) {
            $validator = Validator::make($request->all(), [
                'password' => 'required | confirmed',
            ]);
        }

        if ($validator->fails()) {
            return redirect()->back()->withInput()->with('error', $validator->messages()->first());
        }
*/
        try {
            if ($user = User::find($request->id)) {
                //return 'hbfghfghgf';
                $payload = [
                    'name' => $request->name,
                    'email' => $request->email,
                    'mobile' => $request->mobile,
                    'post_id' => $request->post_id,
                ];
                //return $payload;
                // update password if user input a new password
                if (isset($request->password) && $request->password) {
                    $payload['password'] = $request->password;
                }

                for($i = 0; $i< count($request['post_id']); $i++){

                //UserPost::where('user_id',$request->id)->delete();
                $post['user_id'] = $request->id;
                $post['post_id'] = $request['post_id'][$i];
                UserPost::create($post);

                }

                 $update = $user->update($payload);
                // sync user role
                $user->syncRoles($request->role);

                return redirect()->back()->with('success', 'User information updated succesfully!');
            }

            return redirect()->back()->with('error', 'Failed to update user! Try again.');
        } catch (\Exception $e) {
            $bug = $e->getMessage();

            return redirect()->back()->with('error', $bug);
        }
    }


    /**
     * Delete User
     *
     * @param int $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function delete($id)
    {
        if ($user = User::find($id)) {
            $user->delete();

            return \Response::json(['status'=>'success', 'message'=>'user deleted successfully.']);
        }
        return \Response::json(['status'=>'error', 'message'=>'items User not found.']);
    }
}
