<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pack extends Model
{
    use HasFactory;
    protected $fillable = [
        'title','description','document_type_id','media_type_id','file_url','tenant_id','status','uploadfile'
    ];

    public function documentdetail(){
        return $this->belongsTo('App\Models\DocumentType','document_type_id');
    }

    public function mediadetail(){
        return $this->belongsTo('App\Models\MediaType','media_type_id');
    }
}
