@extends('inventory.layout') 
@section('title', 'Update Check List')
@section('content')
    <!-- push external head elements to head -->
    @push('head')
        <link rel="stylesheet" href="{{ asset('plugins/select2/dist/css/select2.min.css') }}">
       <link rel="stylesheet" href="{{ asset('plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css') }}">
         <link rel="stylesheet" href="{{ asset('plugins/mohithg-switchery/dist/switchery.min.css') }}">
        <style type="text/css">
            .gsterror{
                color: red;
            }
            .emailerror{
                color: red;
            }
            .gstverify{
                color: #4b9732;
            }
            .protable{
                overflow-x: auto;
            }
        </style>
    @endpush

    
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <!-- <i class="ik ik-user-plus bg-blue"></i> -->
                        <div class="d-inline">
                            <h5>Update Check List</h5>
                            <span>{{ __('Update check list')}}</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">{{ __('Update check list')}}</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <form class="forms-sample" method="POST" action="{{ route('updatechecklist',$checklists->id) }}" enctype= multipart/form-data id="Postform">
        @csrf
        @Method('PUT')
        @include('include.message')


            <div class="row">
                <!-- start message area-->
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-header">
                            <strong><h3>{{ __('Basic Information')}}</h3></strong>
                        </div>
                        <div class="card-body">
                            
                            <div class="row">
                               
                                <input id="id" type="hidden" class="form-control" name="id_checklist" value="{{isset($checklists->id_checklist) ? $checklists->id_checklist:''}}" >


                                    
                                <div class="col-sm-6">    
                                    <div class="form-group">
                                        <label for="post_name">Title<span class="text-red">*</span></label>
                                        <input id="title" type="text" class="form-control" name="title" value="{{isset($checklists->title) ? $checklists->title:''}}" placeholder="Enter Title" required="">
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="description">Description</label>
                                        <textarea class="form-control description" name="description" rows="2">{{isset($checklists->description) ? $checklists->description:''}}</textarea>
                                    </div>
                                </div>

                                <div class="col-sm-6">    
                                    <div class="form-group">
                                        <label for="post_name">Media Library</label>
                                        <select  class="form-control " name="id_medialibrary" id="medialibrary">
                                            <option value="">Please Select</option>
                                            @foreach($medias as $media)
                                                @if($media->id==$checklists->id_medialibrary)
                                                    <option value="{{$media->id}}" selected="true">{{isset($media->title) ? $media->title:''}}</option>
                                                @else
                                                    <option value="{{$media->id}}">{{isset($media->title) ? $media->title:''}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-6">    
                                    <div class="form-group">
                                        <label for="post_name">Display Sequence<span class="text-red">*</span></label>
                                        <input id="display_sequence" type="text" class="form-control" name="display_sequence" value="{{isset($checklists->display_sequence) ? $checklists->display_sequence:''}}" placeholder="Enter Display Sequence" required="">
                                    </div>
                                </div>

                                

                                
                            </div>  
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- start message area-->
                
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-body">
                            <div class="col-md-12" style="text-align: center;">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">{{ __('Update')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <!-- push external js -->
    @push('script') 
    
    <script src="{{ asset('plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js') }}"></script>
        <script src="{{ asset('plugins/jquery.repeater/jquery.repeater.min.js') }}"></script>
    <script src="{{ asset('plugins/mohithg-switchery/dist/switchery.min.js') }}"></script>
    <script src="{{ asset('js/form-advanced.js') }}"></script>
    
 

     
    @endpush
@endsection
