@extends('inventory.layout') 
@section('title', 'Clients')
@section('content')
 @push('head')
  
  <style>
    .error{
      color: red;
    }
    /*.searchclass{
        text-transform:capitalize;
    }*/
    .tradeadd{
        background-color: #2dce89;
        border-color: #2dce89;
        color:#fff !important;
    }
    .tradeadd:hover{
    background-color:#2dce89;
    border-color: #2dce89;
    }
    .showmedia{
        padding-right: 10px;
    }


  </style>
  @endpush
    <!-- push external head elements to head --> 
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <!-- <i class="ik ik-users bg-green"></i> -->
                        <div class="d-inline">
                            <h5>Clients</h5>
                            <span>View, delete and update media clients</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">Clients</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <div class="row">
            <!-- list layout 1 start -->
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header row">
                       
                        <div class="col col-sm-6">
                            <div class="card-search with-adv-search dropdown">
                                <form action="{{route('client.index')}}" method="get">
                                    <input type="text" class="form-control global_filter searchclass" id="search" name="search" placeholder="Search.." >
                                    <button type="submit" class="btn btn-icon"><i class="ik ik-search"></i></button>
                                    <button type="button" id="adv_wrap_toggler_1" class="adv-btn ik ik-chevron-down dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></button>
                                    
                                </form>
                            </div>
                        </div>
                        <div class="col col-sm-5">
                            <div class="card-options text-right">
                                <span class="mr-5" id="top">{{($clients->currentpage()-1)*$clients->perpage()+1}} to {{$clients->currentpage()*$clients->perpage()}}
                                            of  {{$clients->total()}} entries</span>
                                <a href="#"><i class="ik ik-chevron-left"></i></a>
                                <a href="#"><i class="ik ik-chevron-right"></i></a>
                                <a href="{{route('client.create')}}" class=" btn btn-outline-primary btn-semi-rounded tradeadd"><i class="ik ik-plus"></i>&nbsp;Add Client</a>
                            </div>
                           
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="product_table" class="table">
                            <thead>
                                <tr>
                                    
                                    <th>{{ __('Name')}}</th>
                                    <th>{{ __('Company')}}</th>
                                    <th>{{ __('City')}}</th>
                                    {{--<th>{{ __('Created')}}</th>--}}
                                    <th style="width: 100px;!important">{{ __('Action')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($clients as $client)
                                <tr>
                                     

                                        <td>{{ isset($client->name) ? $client->name :'' }}</td>

                                        <td>{{ isset($client->company) ? $client->company :'' }}</td> 
                                        <td>{{ isset($client->city) ? $client->city :'' }}</td>
                                        {{--<td>{{ isset($client->created_at) ? $client->created_at :'' }}</td>--}}

                                    
                                    <td> 

                                        <a href="{{route('client.edit', $client->id) }}"  ><i class="ik ik-edit-2  text-green"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                                        <a href="{{route('indexorder', $client->id) }}"  ><i class="ik ik-grid view-icon"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                                        <a href="javascript:;" class="deleteclientid" data-id="{{ isset($client->id) ? $client->id:'' }}"  data-url="{{route('clientdelete',$client['id'])}}"><i class="ik ik-trash-2 f-16 text-red"></i></a>
                                        
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                        <div class="card-footer d-flex align-items-center">

                                <div class="col-md-6">
                                </div>
                                
                                <div class="col-md-6">
                                {{ $clients->links('include.pagination') }}
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- list layout 1 end -->
            <div class="col-md-12"><hr></div>
            <!-- list layout 2 -->
            
            <!-- list layout 2 end -->
        </div>
    </div>
    {{--<div class="modal fade edit-layout-modal pr-0 " id="userAdd" tabindex="-1" role="dialog" aria-labelledby="userAddLabel" aria-hidden="true">
        <div class="modal-dialog w-300" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="categoryAddLabel">{{ __('Add Clients')}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <form class="forms-sample" method="POST" action="{{ route('client.store') }}" id="regForm" enctype= multipart/form-data>
                        @csrf
                    <div class="modal-body">
                     
                            <div class="row">  

                                    <div class="form-group">
                                        <label for="name">{{ __('Name')}}<span class="text-red">*</span></label>
                                        <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="" placeholder="Enter user name" required>
                                        
                                    </div>
                                    <div class="form-group">
                                        <label for="company">{{ __('Company')}}<span class="text-red">*</span></label>
                                        <input id="company" type="text" class="form-control" name="company" value="" placeholder="Enter Company" required>
                                        
                                    </div>
                                    <div class="form-group">
                                        <label for="city">{{ __('City')}}<span class="text-red">*</span></label>
                                        <input id="city" type="city" class="form-control" name="city" value="" placeholder="Enter City" required>
                                       
                                    </div>

                                    <div class="form-group">
                                        <label for="duties">Avatar</label><br>
                                        <input class="" type="file" name="file" id="upload_file">
                                    </div>
                                
                            
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">{{ __('Submit')}}</button>
                                    </div>
                                </div>
                            </div>
                    </div>
                </form>
            </div>
        </div>
    </div>--}}
    <!-- category add modal-->
    {{--<div class="modal fade edit-layout-modal pr-0 " id="categoryView" tabindex="-1" role="dialog" aria-labelledby="categoryViewLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog w-300" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="categoryViewLabel">{{ __('Edit Client')}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <form class="forms-sample" method="POST" action="{{ url('client/update') }}" >
                    @csrf
                    <div class="modal-body">
                     
                            <div class="row">  

                                <div class="form-group">
                                    <label for="name">{{ __('Name')}}<span class="text-red">*</span></label>
                                    <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="" placeholder="Enter user name" required>
                                    
                                </div>
                                <div class="form-group">
                                    <label for="company">{{ __('Company')}}<span class="text-red">*</span></label>
                                    <input id="company" type="text" class="form-control" name="company" value="" placeholder="Enter Company" required>
                                    
                                </div>
                                <div class="form-group">
                                    <label for="city">{{ __('City')}}<span class="text-red">*</span></label>
                                    <input id="city" type="city" class="form-control" name="city" value="" placeholder="Enter City" required>
                                   
                                </div>

                                <div class="form-group">
                                    <label for="duties">Avatar</label><br>
                                    <input class="" type="file" name="file" id="upload_file">
                                </div>
                            
                            
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">{{ __('Submit')}}</button>
                                    </div>
                                </div>
                            </div>
                    </div>
                </form>
            </div>
        </div>
    </div>--}}

@push('script')
<script src="{{ url('js/global.js')}}"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
<script src = "http://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>

<script type="text/javascript">

    var route = "{{ url('clientsearch') }}";
 $('#search').typeahead({
            source: function (query, process) {
                return $.get(route, {
                    query: query
                }, function (data) {
                    console.log(data);
                    return process(data);
                });
            }
        });

 /*$(document).ready(function () {
    $('#product_table').DataTable({
        order: [[3, 'desc']],
    });
});*/
var table = $('#product_table').DataTable({

        paging: false,
        ordering: true,
        info: false,
        searching:false,
    });

</script>
 @endpush
 @endsection