@extends('inventory.layout') 
@section('title', 'Add Order')
@section('content')
    <!-- push external head elements to head -->
    @push('head')
        <link rel="stylesheet" href="{{ asset('plugins/select2/dist/css/select2.min.css') }}">
       <link rel="stylesheet" href="{{ asset('plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css') }}">
         <link rel="stylesheet" href="{{ asset('plugins/mohithg-switchery/dist/switchery.min.css') }}">
        <style type="text/css">
            .gsterror{
                color: red;
            }
            .emailerror{
                color: red;
            }
            .gstverify{
                color: #4b9732;
            }
            .protable{
                overflow-x: auto;
            }
        </style>
    @endpush

    
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <!-- <i class="ik ik-user-plus bg-blue"></i> -->
                        <div class="d-inline">
                            <h5>{{isset($client->name) ? $client->name:''}} Order</h5>
                            <span>{{ __('Create order')}}</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">{{ __('Add Order')}}</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
       <form class="forms-sample" method="POST" action="{{ route('order.store') }}" id="regForm" enctype= multipart/form-data>
                        @csrf
        @include('include.message')

            <div class="row">
                <!-- start message area-->
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-header">
                            <strong><h3>{{ __('Basic Information')}}</h3></strong>
                        </div>
                        <div class="card-body">
                            
                    <div class="row">  
                        <input type="hidden" name="clientId" value="{{isset($clientid) ? $clientid:''}}">
                        {{--<div class="col-sm-6">  
                            <div class="form-group">
                            <label for="name">{{ __('Select Client')}}<span class="text-red">*</span></label>
                                <select  class="form-control " name="clientId" id="client">
                                <option value="">Please Select</option>
                                    @foreach($clients as $client)
                                    
                                            <option value="{{$client->id}}" selected="true">{{isset($client->name) ? $client->name:''}}</option>
                                    @endforeach 
                                </select>
                            </div>
                        </div>--}}

                        <div class="col-sm-6"> 
                            <div class="form-group">
                                <label for="name">{{ __('Routing Form')}}<span class="text-red">*</span></label>
                                <select  class="form-control " name="routingformId" id="routing">
                                <option value="">Please Select</option>
                                    @foreach($routings as $routing)
                                    
                                        <option value="{{$routing->id}}" >{{isset($routing->routingName) ? $routing->routingName:''}}</option>
                                    @endforeach
                                </select>
                                {{--<label for="name">{{ __('Routing Form')}}</label>
                                <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="routingformId" value="" placeholder="Enter Routing Form">--}}
                           </div>     
                        </div>

                        <div class="col-sm-6"> 
                            <div class="form-group">
                                <label for="name">{{ __('Customer Name')}}<span class="text-red">*</span></label>
                                <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="customerName" value="" placeholder="Enter Name" required>
                           </div>     
                        </div>
                        <div class="col-sm-6">  
                            <div class="form-group">
                                <label for="company">{{ __('Contact Person')}}<span class="text-red">*</span></label>
                                <input id="company" type="text" class="form-control" name="contactPerson" value="" placeholder="Enter Contact Person" required>
                            </div>   
                        </div>  

                        <div class="col-sm-6">  
                            <div class="form-group">
                                <label for="company">{{ __('Contact Number')}}<span class="text-red">*</span></label>
                                <input id="company" type="text" class="form-control" name="contactNumber" value="" placeholder="Enter Contact Number" required>
                            </div>   
                        </div>

                        <div class="col-sm-6">  
                            <div class="form-group">
                                <label for="company">{{ __('Address')}}<span class="text-red">*</span></label>
                                <textarea class="form-control description" name="Address" rows="2"></textarea>
                            </div>   
                        </div>

                        <div class="col-sm-6">  
                            <div class="form-group">
                                <label for="state">{{ __('State')}}<span class="text-red">*</span></label>
                                <select  class="form-control " name="state" id="state">
                                    <option value="">Please Select</option>
                                    
                                        <option value="10">Maharashtra</option>
                                        <option value="20">Delhi</option>
                                </select>                                    
                            </div>   
                        </div>
                                    

                        <div class="col-sm-6">  
                            <div class="form-group">
                                <label for="city">{{ __('City')}}<span class="text-red">*</span></label>
                                <select  class="form-control " name="city" id="city">
                                    <option value="">Please Select</option>
                                    
                                        <option value="101">Pune</option>
                                        <option value="201">Mumbai</option>
                                </select>
                                
                               
                            </div>
                        </div>
                                <div class="col-sm-6">  
                                    <div class="form-group">
                                        <label for="company">{{ __('Zipcode')}}<span class="text-red">*</span></label>
                                        <input id="zip" type="text" class="form-control" name="zip" value="" placeholder="Enter Zipcode" required>
                                    </div>   
                                    </div>   

                                     <div class="col-sm-6">  
                                    <div class="form-group">
                                        <label for="whatsappLocation">{{ __('Whatsapp Location')}}<span class="text-red">*</span></label>
                                        <input id="whatsapp" type="text" class="form-control" name="whatsappLocation" value="" placeholder="Enter Whatsapp Location" required>
                                    </div>   
                                    </div>                         
                    
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- start message area-->
                
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-body">
                            <div class="col-md-12" style="text-align: center;">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">{{ __('Add')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <!-- push external js -->
    @push('script') 
    
    <script src="{{ asset('plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js') }}"></script>
        <script src="{{ asset('plugins/jquery.repeater/jquery.repeater.min.js') }}"></script>
    <script src="{{ asset('plugins/mohithg-switchery/dist/switchery.min.js') }}"></script>
    <script src="{{ asset('js/form-advanced.js') }}"></script>
    
 

     
    @endpush
@endsection
