@extends('inventory.layout') 
@section('title', 'Add Tenant')
@section('content')
    <!-- push external head elements to head -->
    @push('head')
        <link rel="stylesheet" href="{{ asset('plugins/select2/dist/css/select2.min.css') }}">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.css">
        <style type="text/css">
            .gsterror{
                color: red;
            }
            .emailerror{
                color: red;
            }
            .gstverify{
                color: #4b9732;
            }
            .protable{
                overflow-x: auto;
            }
        </style>
    @endpush

    
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <i class="ik ik-user-plus bg-blue"></i>
                        <div class="d-inline">
                            <h5>{{ __('Add Tenant')}}</h5>
                            <span>{{ __('Create Add Tenant')}}</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">{{ __('Add Tenant')}}</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <form class="forms-sample" method="POST" action="{{ route('tenant.store') }}" enctype= multipart/form-data id="Postform">
        @csrf
        @include('include.message')

            <div class="row">
                <!-- start message area-->
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-header">
                            <strong><h3>{{ __('Basic Information')}}</h3></strong>
                        </div>
                        <div class="card-body">
                            
                            <div class="row">
                            
                                <div class="col-sm-6">    
                                    <div class="form-group">
                                        <label for="post_name">Name<span class="text-red">*</span></label>
                                        <input id="title" type="text" class="form-control" name="name" value="" placeholder="Enter Name" required="">
                                    </div>
                                </div>
                                

                                <div class="col-sm-6">
                                    <div class="form-group">
                                    <label for="mobile">Mobile No.<span class="text-red">*</span></label>
                                    
                                     <input type="tel" id="second_mobile" class="form-control" name="mobile" required=""> 
                                    <div id="secondmblerror"></div>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                    <label for="secondary_email">Email<span class="text-red">*</span></label>
                                    <input id="email" type="text" class="form-control secondary_email" name="email" value="" placeholder="Enter Email" required="">
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                    <label for="state">State</label>
                                    <select  class="form-control" name="state_id" id="tradestate" data-url="{{route('getCity')}}">

                                        <option value="">Select State</option> 
                                            @foreach($states as $state)
                                                <option value="{{$state->id}}">{{$state->name}}</option> 
                                             @endforeach
                                        
                                    </select>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="city">City</label>
                                        <select  class="form-control" name="city_id" id="tradecity">
                                            
                                        </select>
                                        
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="pincode">Pincode</label>
                                        <input id="pincode" type="text" class="form-control" name="pincode" placeholder="Enter Pincode">
                                        
                                    </div> 
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Address Line 1</label>
                                        <textarea class="form-control" name="address" rows="2"></textarea>

                                    </div>
                                </div>
                            </div>  
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- start message area-->
                
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-body">
                            <div class="col-md-12" style="text-align: center;">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">{{ __('Add')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <!-- push external js -->
    @push('script') 
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
    <script>
        $('#tradestate').on('change', function() {
                
                var state_id = $(this).val();
                console.log(state_id);
                var url=$(this).data('url');
                console.log(url);
                 $("#tradecity").html('');
                $.ajax({
                    url:url,
                    type: "GET",
                    data: {
                        state_id: state_id
                    },
                    dataType : 'json',
                    success: function(result){
                        console.log(result);
                        $.each(result.city,function(key,value){
                        $("#tradecity").append('<option value="'+value.id+'">'+value.name+'</option>');
                        });
                    }
                });
            
            
        });
     </script>
    @endpush
@endsection
