@extends('inventory.layout') 
@section('title', 'Add User Group')
@section('content')
    <!-- push external head elements to head -->
    @push('head')
        <link rel="stylesheet" href="{{ asset('plugins/select2/dist/css/select2.min.css') }}">
       <link rel="stylesheet" href="{{ asset('plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css') }}">
         <link rel="stylesheet" href="{{ asset('plugins/mohithg-switchery/dist/switchery.min.css') }}">
         <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.css">
        <style type="text/css">
            .gsterror{
                color: red;
            }
            .emailerror{
                color: red;
            }
            .gstverify{
                color: #4b9732;
            }
            .protable{
                overflow-x: auto;
            }
        </style>
    @endpush

    
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <!-- <i class="ik ik-user-plus bg-blue"></i> -->
                        <div class="d-inline">
                            <h5>User Group</h5>
                            <span>{{ __('Create User Group')}}</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">{{ __('Add User Group')}}</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
       <form class="forms-sample" method="POST" action="{{ route('usergroup.store') }}" id="regForm" enctype= multipart/form-data>
                        @csrf
        @include('include.message')

            <div class="row">
                <!-- start message area-->
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-header">
                            <strong><h3>{{ __('Basic Information')}}</h3></strong>
                        </div>
                        <div class="card-body">
                            
                            <div class="row">  
                                <div class="col-sm-6">  
                                    <div class="form-group">
                                        <label for="name">{{ __('Group Name')}}<span class="text-red">*</span></label>
                                        <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="groupName" value="" placeholder="Enter groupName" required>
                                   </div>     
                                </div>
                                <div class="col-sm-6">  
                                    <div class="form-group">
                                        <label for="company">{{ __('Users')}}<span class="text-red">*</span></label>
                                        <select  class="form-control select2" name="user_id[]" id="user" multiple="multiple" required="">
                                            <option value="">Please Select</option>
                                            @foreach($users as $user)
                                                <option value="{{$user->id}}">{{$user->name}}</option>
                                            @endforeach
                                        </select>
                                   </div>   
                                </div>
                                    
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- start message area-->
                
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-body">
                            <div class="col-md-12" style="text-align: center;">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">{{ __('Add')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <!-- push external js -->
    @push('script') 
    <script src="{{ asset('plugins/select2/dist/js/select2.min.js') }}"></script>

    <script src="{{ asset('plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js') }}"></script>

    <script src="{{ asset('plugins/jquery.repeater/jquery.repeater.min.js') }}"></script>
    <script src="{{ asset('plugins/mohithg-switchery/dist/switchery.min.js') }}"></script>
    <script src="{{ asset('js/form-advanced.js') }}"></script>
    
    

     
    @endpush
@endsection
