 
<?php $__env->startSection('title', 'Edit Tenant'); ?>
<?php $__env->startSection('content'); ?>
    <!-- push external head elements to head -->
    <?php $__env->startPush('head'); ?>
        <link rel="stylesheet" href="<?php echo e(asset('plugins/select2/dist/css/select2.min.css')); ?>">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.css">
        <style type="text/css">
            .gsterror{
                color: red;
            }
            .emailerror{
                color: red;
            }
            .gstverify{
                color: #4b9732;
            }
            .protable{
                overflow-x: auto;
            }
        </style>
    <?php $__env->stopPush(); ?>

    
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <i class="ik ik-user-plus bg-blue"></i>
                        <div class="d-inline">
                            <h5><?php echo e(__('Edit Tenant')); ?></h5>
                            <span><?php echo e(__('Edit Tenant')); ?></span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(url('dashboard')); ?>"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#"><?php echo e(__('Edit Tenant')); ?></a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <form class="forms-sample" method="POST" action="<?php echo e(route('tenant.update',$tenant->id)); ?>" enctype= multipart/form-data id="Postform">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <?php echo $__env->make('include.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="row">
                <!-- start message area-->
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-header">
                            <strong><h3><?php echo e(__('Basic Information')); ?></h3></strong>
                        </div>
                        <div class="card-body">
                            
                            <div class="row">
                            
                                <div class="col-sm-6">    
                                    <div class="form-group">
                                        <label for="post_name">Name<span class="text-red">*</span></label>
                                        <input id="title" type="text" class="form-control" name="name" value="<?php echo e(isset($tenant->name) ? $tenant->name : ''); ?>" placeholder="Enter Name" required="">
                                    </div>
                                </div>
                                

                                <div class="col-sm-6">
                                    <div class="form-group">
                                    <label for="mobile">Mobile No.<span class="text-red">*</span></label>
                                    
                                     <input type="tel" id="second_mobile" class="form-control" name="mobile" value="<?php echo e(isset($tenant->mobile) ? $tenant->mobile : ''); ?>" required=""> 
                                    <div id="secondmblerror"></div>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                    <label for="secondary_email">Email<span class="text-red">*</span></label>
                                    <input id="email" type="text" class="form-control secondary_email" name="email" value="<?php echo e(isset($tenant->email) ? $tenant->email : ''); ?>" placeholder="Enter Email" required="">
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                    <label for="state">State</label>
                                    <select  class="form-control" name="state_id" id="tradestate" data-url="<?php echo e(route('getCity')); ?>">

                                        <option value="">Select State</option> 
                                            <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($state->exists && $state->id == $tenant->state_id): ?>
                                                        <option value="<?php echo e($state->id); ?>" selected="selected"><?php echo e($state->name); ?></option>

                                                    <?php else: ?>
                                                        <option value="<?php echo e($state->id); ?>"><?php echo e($state->name); ?></option> 
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        
                                    </select>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="city">City</label>
                                        <select  class="form-control" name="city_id" id="tradecity">

                                            <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($city->exists && $city->id == $tenant->city_id): ?>
                                                    <option value="<?php echo e($city->id); ?>" selected="selected"><?php echo e($city->name); ?></option>

                                                <?php else: ?>
                                                    <option value="<?php echo e($city->id); ?>"><?php echo e($city->name); ?></option> 
                                                <?php endif; ?>
                                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            
                                        </select>
                                        
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="pincode">Pincode</label>
                                        <input id="pincode" type="text" class="form-control" name="pincode" placeholder="Enter Pincode" value="<?php echo e(isset($tenant->pincode) ? $tenant->pincode : ''); ?>">
                                        
                                    </div> 
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Address Line 1</label>
                                        <textarea class="form-control" name="address" rows="2"><?php echo e(isset($tenant->address) ? $tenant->address : ''); ?></textarea>

                                    </div>
                                </div>
                            </div>  
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- start message area-->
                
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-body">
                            <div class="col-md-12" style="text-align: center;">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary"><?php echo e(__('Update')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <!-- push external js -->
    <?php $__env->startPush('script'); ?> 
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
    <script>
        $('#tradestate').on('change', function() {
                
                var state_id = $(this).val();
                console.log(state_id);
                var url=$(this).data('url');
                console.log(url);
                 $("#tradecity").html('');
                $.ajax({
                    url:url,
                    type: "GET",
                    data: {
                        state_id: state_id
                    },
                    dataType : 'json',
                    success: function(result){
                        console.log(result);
                        $.each(result.city,function(key,value){
                        $("#tradecity").append('<option value="'+value.id+'">'+value.name+'</option>');
                        });
                    }
                });
            
            
        });
     </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('inventory.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\wiseadmin\resources\views/tenant/edit.blade.php ENDPATH**/ ?>