@extends('inventory.layout') 
@section('title', 'Edit Vendor')
@section('content')
    <!-- push external head elements to head -->
    @push('head')
        <link rel="stylesheet" href="{{ asset('plugins/select2/dist/css/select2.min.css') }}">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.css">
        <style type="text/css">
            .gsterror{
                color: red;
            }
            .emailerror{
                color: red;
            }
        </style>
    @endpush

    
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <i class="ik ik-user-plus bg-blue"></i>
                        <div class="d-inline">
                            <h5>{{ __('Edit Vendor')}}</h5>
                            <span>{{ __('Edit Vendor')}}</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">{{ __('Edit Vendor')}}</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <form class="forms-sample" method="POST" action="{{ route('vendor.update',$vendor->id) }}" enctype= multipart/form-data>
            @csrf
            @method('PUT')
            <!-- start message area-->
            @include('include.message')
            <!-- end message area-->
        <div class="row">
                <!-- start message area-->
                
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-header">
                            <strong><h3>{{ __('Basic Information')}}</h3></strong>
                        </div>
                        <div class="card-body">
                            
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                           <label class="d-block">Product Group</label>
                                            
                                                <input id="product_group" type="text" class="form-control" name="product_group" value="{{isset($vendor->product_group) ? $vendor->product_group:''}}" placeholder="Enter First Name" required="">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                           <label class="d-block">Parent Category</label>
                                           <input id="search" type="text" class="form-control parentcat" name="category_id" value="{{isset($vendor->category->name) ? $vendor->category->name:''}}" placeholder="Enter Category" required="" data-url="{{url('childcat')}}">
                                            {{-- <select  class="form-control parentcat" name="category_id"  id="search" data-url="{{url('/')}}">

                                            <option value="">Select Category</option> 
                                              @foreach($category as $cat)
                                                <option value="{{$cat->id}}">{{$cat->name}}</option> 
                                              @endforeach
                                
                                            </select> --}}
                                        </div>
                                    </div>

                                    {{--<div class="col-sm-6">
                                        <div class="form-group">
                                           <label class="d-block">Sub Category</label>
                                           <input id="subcat" type="text" class="form-control subcat" name="subcategory_id" value="" placeholder="Enter Sub Category" required="" data-url="{{url('/')}}">
                                             <select  class="form-control parentcat" name="category_id"  id="search" data-url="{{url('/')}}">

                                            <option value="">Select Category</option> 
                                              @foreach($category as $cat)
                                                <option value="{{$cat->id}}">{{$cat->name}}</option> 
                                              @endforeach
                                
                                            </select> 
                                        </div>
                                    </div>--}}
                                    <div class="col-sm-6">
                                    <div class="form-group subcategory">
                                        <label class="d-block">Sub Category</label>
                                        <select  class="form-control subcat" name="subcategory_id" data-url="{{url('/')}}">

                                        <option value="">Select Category</option>

                                            @foreach($category as $cat)
                                             
                                                <option value="{{$cat->id}}" {{ isset($cat->id) && $cat->id == $vendor->subcategory_id ? 'selected' :''}}>{{$cat->name}}</option> 
                                              
                                            @endforeach
                            
                                        </select>
                                    </div>
                                    </div>
                                    <div class="form-group childcategory" >
                                    </div>

                                        <div class="col-sm-6">    
                                            <div class="form-group">
                                                <label for="bussiness_nature">Nature Of Business <span class="text-red">*</span></label>
                                                <input id="bussiness_nature" type="text" class="form-control" name="bussiness_nature" value="{{$vendor->bussiness_nature}}" placeholder="Enter bussiness Nature" required="">
                                                <div class="help-block with-errors"></div>


                                            </div>
                                        </div>
                                        
                                        <div class="col-sm-6">    
                                            <div class="form-group">
                                                <label for="company_name">Company Name<span class="text-red">*</span></label>
                                                <input id="company_name" type="text" class="form-control" name="company_name" value="{{$vendor->company_name}}" placeholder="Enter Company Name" required="">
                                                <div class="help-block with-errors"></div>


                                            </div>
                                        </div>
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- start message area-->
                
                <!-- end message area-->
                <div class="col-md-6">
                    <div class="card ">
                        <div class="card-header">
                            <strong><h3>{{ __('Primary Information')}}</h3></strong>
                        </div>
                        <div class="card-body">
                                        <div class="form-group">
                                            <label for="primary_contact_person">Name</label>
                                            <input id="primary_contact_person" type="text" class="form-control" name="primary_contact_person" value="{{$vendor->primary_contact_person}}" placeholder="Enter Name">
                                            <div class="help-block with-errors"></div>
                                        </div>
                                
                                    <div class="form-group">
                                        <label for="designation">Designation</label>
                                        <input id="designation" type="text" class="form-control" name="designation" value="{{$vendor->designation}}" placeholder="Enter designation">
                                        <div class="help-block with-errors"></div>
                                    </div>
                                
                                    <div class="form-group">
                                        <label for="email">Email<span class="text-red">*</span></label>
                                        <input id="email" type="text" class="form-control email" name="email" value="{{$vendor->email}}" placeholder="Enter Email" required="">
                                        <span class="emailerror"></span>
                                        <div class="help-block with-errors"></div>
                                    </div>
                               
                                    <div class="form-group">
                                        <label for="mobile">Mobile</label>
                                        <input type="hidden" name="coun_code" id="count_code" value="91">
                                         <input type="tel" id="number" class="form-control" name="mobile" value="{{$vendor->mobile}}" > 
                                        <!-- <input id="mobile" type="text" class="form-control" name="mobile" value="" placeholder="Enter Mobile" maxlength="10" required>  -->
                                        <span id="lblError" style="color: red"></span>
                                        <div class="help-block with-errors"></div>
                                    </div>
                                
                                    <div class="form-group">
                                        <label for="landline">Landline</label>
                                        <div class="row">
                                        <div class="col-sm-6">
                                        <input id="city_code" type="text" class="form-control" name="city_code" value="{{$vendor->city_code}}" placeholder="Enter Code">
                                        </div>
                                        <div class="col-sm-6">
                                        <input id="landline" type="text" class="form-control" name="landline" value="{{$vendor->landline}}" placeholder="Enter Landline">
                                        </div>
                                        </div>
                                        <span id="lndlineError" style="color: red"></span>
                                        <div class="help-block with-errors"></div>
                                    </div>
                            
                                    <div class="form-group">
                                        <label for="country">Country<span class="text-red">*</span></label>
                                        <select  class="form-control" name="country_id" id="country" >
                                        <option value="">Select Country</option> 
                                            @foreach($countries as $country)
                                                @if($country->id==$vendor->country_id)
                                                    <option value="{{$country->id}}" selected="selected">{{$country->name}}</option> 
                                                @else
                                                    <option value="{{$country->id}}">{{$country->name}}</option> 
                                                @endif
                                             @endforeach
                                        
                                        </select>
                                        <span class="emailerror"></span>
                                        <div class="help-block with-errors"></div>
                                    </div>
                                

                                <div class="form-group">
                                    <label for="state">State</label>
                                    <select  class="form-control" name="state_id" id="tradestate" data-url="{{route('getCity')}}">

                                        <option value="">Select State</option> 
                                            @foreach($states as $state)
                                            
                                                    @if($state->exists && $state->id == $vendor->state_id)
                                                        <option value="{{ $state->id }}" selected="selected">{{ $state->name }}</option>

                                                    @else
                                                        <option value="{{$state->id}}">{{$state->name}}</option> 

                                                    @endif
                                             @endforeach
                                        
                                        </select>
                                    <div class="help-block with-errors"></div>
                                </div>
                           

                                <div class="form-group">
                                    <label for="city">City</label>
                                    <select  class="form-control" name="city_id" id="tradecity">
                                        <option value="">Select City</option> 
                                            @foreach($cities as $city)
                                                @if($city->exists && $city->id == $vendor->city_id)
                                                    <option value="{{ $city->id }}" selected="selected">{{ $city->name }}</option>

                                                @else
                                                    <option value="{{$city->id}}">{{$city->name}}</option> 
                                                @endif
                                             @endforeach
                                            
                                    </select>
                                    <div class="help-block with-errors"></div>
                                </div>

                                <div class="form-group">
                                    <label>Address</label>
                                    <textarea class="form-control" name="address_1" rows="2">{{isset($vendor->address_1) ? $vendor->address_1:''}}</textarea>

                                </div>

                                <div class="form-group">
                                    <label for="pincode">Pincode</label>
                                    <input id="pincode" type="text" class="form-control" name="pincode" placeholder="Enter Pincode" value="{{isset($vendor->pincode) ? $vendor->pincode:''}}" required="">
                                    <div class="help-block with-errors"></div>
                                </div>        
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card ">
                        <div class="card-header">
                            <strong><h3>{{ __('Secondary Information')}}</h3></strong>
                            <!-- <div><button type="button" class="class=" name="billingtoo" onclick="FillBilling(this.form)" btn=""style="margin-left: 174px;background-color: #19B5FE !important;color:#fff;border: #19B5FE;">
                            Copy Address
                        </button></div> -->
                        </div>
                        <div class="card-body">
                            
                                        
                                            <div class="form-group">
                                                <label for="secondary_contact_person">Name</label>
                                                <input id="secondary_contact_person" type="text" class="form-control" name="secondary_contact_person" value="{{isset($vendor->secondary_contact_person) ? $vendor->secondary_contact_person:''}}" placeholder="Enter Name">
                                                <div class="help-block with-errors"></div>


                                            </div>
                                        
                                            <div class="form-group">
                                                <label for="secondary_designation">Designation</label>
                                                <input id="secondary_designation" type="text" class="form-control" name="secondary_designation" value="{{isset($vendor->secondary_designation) ? $vendor->secondary_designation:''}}" placeholder="Enter designation">
                                                <div class="help-block with-errors"></div>


                                            </div>
                                        
                                            <div class="form-group">
                                                <label for="secondary_email">Email<span class="text-red">*</span></label>
                                                <input id="secondary_email" type="text" class="form-control secondary_email" name="secondary_email" value="{{isset($vendor->secondary_email) ? $vendor->secondary_email:''}}" placeholder="Enter Email" required="">
                                                <span class="emailerror"></span>
                                                <div class="help-block with-errors"></div>
                                            </div>
                                        
                                            <div class="form-group">
                                                <label for="secondary_mobile">Mobile</label>
                                                <input type="hidden" name="second_coun_code" id="second_count_code" value="91">

                                                 <input type="tel" id="mobile" class="form-control" name="secondary_mobile" value="{{isset($vendor->secondary_mobile) ? $vendor->secondary_mobile:''}}"> 
                                                <!-- <input id="mobile" type="text" class="form-control" name="mobile" value="" placeholder="Enter Mobile" maxlength="10" required>  -->
                                                <span id="mblError" style="color: red"></span>
                                                <div class="help-block with-errors"></div>
                                            </div>
                                        
                                            <div class="form-group">
                                                <label for="landline">Landline</label>
                                                <div class="row">
                                                <div class="col-sm-6">
                                                <input id="city_code" type="text" class="form-control" name="second_city_code" value="{{$vendor->second_city_code}}" placeholder="Enter Code">
                                                </div>
                                                <div class="col-sm-6">
                                                <input id="landline" type="text" class="form-control" name="second_landline" value="{{isset($vendor->second_landline) ? $vendor->second_landline:''}}" placeholder="Enter Landline">
                                                </div>
                                                </div>
                                                <span id="lndlineError" style="color: red"></span>
                                                <div class="help-block with-errors"></div>
                                            </div>
                                        
                                        <div class="form-group">
                                            <label for="country">Country</label>
                                            <select  class="form-control" name="secondary_country_id" id="secondcountry" >

                                                <option value="">Select Country</option> 
                                                    @foreach($countries as $country)
                                                        @if($country->id==$vendor->secondary_country_id)
                                                            <option value="{{$country->id}}" selected="selected">{{$country->name}}</option> 
                                                        @else
                                                            <option value="{{$country->id}}">{{$country->name}}</option> 
                                                        @endif
                                                    @endforeach
                                                
                                                </select>
                                            <div class="help-block with-errors"></div>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="state">State</label>
                                            <select  class="form-control" name="secondary_state_id" id="secondarystate" data-url="{{route('getCity')}}">

                                                <option value="">Select State</option> 
                                                    @foreach($states as $state)
                                                        @if($state->exists && $state->id == $vendor->secondary_state_id)
                                                                <option value="{{ $state->id }}" selected="selected">{{ $state->name }}</option>

                                                        @else
                                                            <option value="{{$state->id}}">{{$state->name}}</option>
                                                        @endif 
                                                     @endforeach
                                                
                                                </select>
                                            <div class="help-block with-errors"></div>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="city">City</label>
                                            <select  class="form-control" name="secondary_city_id" id="secondarycity">
                                                <option value="">Select City</option> 
                                                    @foreach($cities as $city)
                                                        @if($city->exists && $city->id == $vendor->city_id)
                                                                <option value="{{ $city->id }}" selected="selected">{{ $city->name }}</option>

                                                        @else
                                                            <option value="{{$city->id}}">{{$city->name}}</option> 
                                                        @endif
                                                     @endforeach
                                            </select>
                                            <div class="help-block with-errors"></div>
                                        </div>

                                        <div class="form-group">
                                            <label>Secondary Address</label>
                                            <textarea class="form-control" name="address_2" rows="2">{{isset($vendor->address_2) ? $vendor->address_2 :''}}</textarea>

                                        </div>   
                                        
                                        <div class="form-group">
                                            <label for="secondpincode">Pincode</label>
                                            <input id="secondpincode" type="text" class="form-control" name="secondary_pincode" value="{{isset($vendor->secondary_pincode) ? $vendor->secondary_pincode:''}}" placeholder="Enter Pincode" required="">
                                            <div class="help-block with-errors"></div>
                                        </div>
                                        
                                        
                                             
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- start message area-->
                
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-body">
                            <div class="col-md-12" style="text-align: center;">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">{{ __('Submit')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </div>
    <!-- push external js -->
    @push('script') 
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>

    <script type="text/javascript">

    var route = "{{ url('categorysearch') }}";
 $('#search').typeahead({
            source: function (query, process) {
                return $.get(route, {
                    query: query
                }, function (data) {
                    return process(data);
                });
            }
        });

 /*var route = "{{ url('categorysearch') }}";
 $('#subcat').typeahead({
            source: function (query, process) {
                return $.get(route, {
                    query: query
                }, function (data) {
                    return process(data);
                });
            }
        });*/
    </script>

    <script>
        $('.parentcat').change(function() { 
            //console.log('gfbhngfgfh');
            var parent = $('.parentcat').val();
            //console.log(parent);
            var publicurl= $(this).data('url');
            //console.log(publicurl);
            if(parent!=''){

                $.ajax({
                    url:publicurl,
                    type:'GET',
                    data:{'name':parent},
                    success:function(data){
                        console.log(data);
                        var row='';
                            row+='<label class="d-block">Sub Category</label>';
                            row+='<select class="form-control subcat" name="subcategory_id" data-url='+publicurl+'>';
                            row+='<option value=>Select Parent</option>';
                            jQuery.each(data, function(i, cat){
                                row+='<option value='+cat['id']+'>'+cat['name']+'</option>';
                            });
                            row+='</select>';
                        
                            $('.subcategory').html(row);
                    }
                });
              
            }
        });

        
    </script> 

    <script type="text/javascript">
        $(function () {
        $('#dropify').dropify();
        });
        $('#tradestate').on('change', function() {
            //alert('xdvgdfgdf');
            var state_id = this.value;
            console.log(state_id);
            var url=$(this).data('url');
            console.log(url);
             $("#tradecity").html('');
            $.ajax({
                url:url,
                type: "GET",
                data: {
                    state_id: state_id
                },
                dataType : 'json',
                success: function(result){
                    console.log(result);
                    $.each(result.city,function(key,value){
                    $("#tradecity").append('<option value="'+value.id+'">'+value.name+'</option>');
                    });
                }
            });
        
        
        });

        $('#secondarystate').on('change', function() {
            //alert('xdvgdfgdf');
            var state_id = this.value;
            console.log(state_id);
            var url=$(this).data('url');
            console.log(url);
             $("#secondarycity").html('');
            $.ajax({
                url:url,
                type: "GET",
                data: {
                    state_id: state_id
                },
                dataType : 'json',
                success: function(result){
                    console.log(result);
                    $.each(result.city,function(key,value){
                    $("#secondarycity").append('<option value="'+value.id+'">'+value.name+'</option>');
                    });
                }
            });
        
        
        });
    </script>
    <!-- image -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js"></script>

<link href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/css/intlTelInput.css" rel="stylesheet" media="screen">
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/intlTelInput.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/intlTelInput.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/utils.js"></script>
   

<script type="text/javascript">        
$(document).ready(function () {        
    
$(".email").change(function () {    
var inputvalues = $(this).val();    
var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;    
if(!regex.test(inputvalues)){    
$(".emailerror").html("invalid email id");    
return regex.test(inputvalues);    
}    

});    
    
});  

$("#number").intlTelInput();  
$("#mobile").intlTelInput();  

  $(function () {
        $("#number").keypress(function (e) {
            var num=$(this).value;
            //alert(num);
            var keyCode = e.keyCode || e.which;
 
            $("#lblError").html("");
 
            //Regex for Valid Characters i.e. Numbers.
            var regex = /^[0-9]+$/;
            
            //Validate TextBox value against the Regex.
            var isValid = regex.test(String.fromCharCode(keyCode));
            if (!isValid) {
                $("#lblError").html("Only Numbers allowed.");
                return false;  
            }
            else{
                return true;
            }
 
            //return isValid;
        });
    });   


    $(function () {
        $("#mobile").keypress(function (e) {
            //alert('dgfdfhh');
            var num=$(this).value;
            //alert(num);
            var keyCode = e.keyCode || e.which;
 
            $("#mblError").html("");
 
            //Regex for Valid Characters i.e. Numbers.
            var regex = /^[0-9]+$/;
            
            //Validate TextBox value against the Regex.
            var isValid = regex.test(String.fromCharCode(keyCode));
            if (!isValid) {
                $("#mblError").html("Only Numbers allowed.");
                e.preventDefault();
                return false;  
            }
            else{
                return true;
            }
 
            //return isValid;
        });
    });   

$(document).ready(function () {        
    
$("#number").change(function () {   
var getCode = $(this).intlTelInput('getSelectedCountryData').dialCode;
console.log(getCode);
$('#count_code').val(getCode);
var inputvalues = $(this).val();    
var regex = /^(\+?\d{1,4}[\s-])?(?!0+\s+,?$)\d{10}\s*,?$/;
              if(!regex.test(inputvalues)){    
                $("#lblError").html("invalid mobile number");    
                return regex.test(inputvalues);  
                return false;  
                }      

});   


$("#mobile").change(function (event) {   
var getCode = $(this).intlTelInput('getSelectedCountryData').dialCode;
console.log(getCode);
$('#second_count_code').val(getCode);
var inputvalues = $(this).val();    
var regex = /^(\+?\d{1,4}[\s-])?(?!0+\s+,?$)\d{10}\s*,?$/;
              if(!regex.test(inputvalues)){    
                $("#mblError").html("invalid mobile number");    
                //return regex.test(inputvalues); 
                event.preventDefault(); 
                return false;  
                }      

});   


/*$("#landline").change(function () {    
var inputvalues = $(this).val();    
var regex = /^[\d]{3,4}[\-\s]*[\d]{6,7}$/;
              if(!regex.test(inputvalues)){    
                $("#lndlineError").html("invalid mobile number");    
                return regex.test(inputvalues);   
                return false;   
                }      

});    */
    
}); 

</script> 
    @endpush
@endsection
