<?php

namespace App\Http\Controllers;
use App\User;
use Auth;
use DB;
use App\RoutingMaster;
use App\Http\Requests\RoutingMasterStoreRequest;
use Illuminate\Http\Request;

class RoutingMasterController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index() {

            $routingmaster = RoutingMaster::get();     
        
        

        return response()->json([
            'data' => $routingmaster
        ]);
    }

    /**
     * Get single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show( RoutingMaster $routingmaster ) {

        return response()->json([
            'data' => $routingmaster
        ]);
    }

    /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update( RoutingMasterStoreRequest $request, RoutingMaster $routingmaster ) {
        $routingmaster->fill($request->all());
		//User Information Details Submit
        $routingmaster->save();
        return response()->json([
            'status' => true,
            'data' => $routingmaster
        ]);
    }

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store( RoutingMasterStoreRequest $request ) {
        $routingmaster = new RoutingMaster;
        $routingmaster->fill($request->all());
        //User Id Generate Dynamically.
        $year = date("Y");
        $year = substr( $year, -2);
        $month = date("m");
        //Fetch last company id from CompanyMaster
        $lastroutingid=DB::table('routing')
       ->select('routing.routingId')->OrderBy('routing.routingId', 'DESC')->first();
        if($lastroutingid==NULL){
           
            $bId = "1";
		}
		else{
            $lastroutingid = $lastroutingid->routingId;
            $lastroutingid = substr( $lastroutingid, -6);
            $sequence = $lastroutingid + 1;
            $bId = $sequence;
		}
       
        //User Information Details Submit
        $routingmaster->routingId = $bId;
        $routingmaster->save();

        return response()->json([
            'status' => true,
            'created' => true,
            'data' => [
                'id' => $bId
            ]
        ]);
    }

    /**
     * Destroy single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy( RoutingMaster $routingmaster ) {
       
        $routingmaster->delete();
        //echo "amar";
        return response()->json([
            'status' => true
        ]);
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroyMass( Request $request ) {
        $request->validate([
            'ids' => 'required|array'
        ]);

        RoutingMaster::destroy($request->ids);

        return response()->json([
            'status' => true
        ]);
    }
}
