<?php

namespace App\Http\Controllers;
use App\User;
use Auth;
use DB;
use App\UserGroup;
use App\Http\Requests\UserGroupStoreRequest;
use Illuminate\Http\Request;

class UserGroupController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Index resource
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index() {

            $usergroup = UserGroup::get();     
        
        

        return response()->json([
            'data' => $usergroup
        ]);
    }

    /**
     * Get single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show( UserGroup $usergroup ) {

        return response()->json([
            'data' => $usergroup
        ]);
    }

    /**
     * Update single resource
     *
     * @param ClientStoreRequest $request
     * @param Client $client
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update( UserGroupStoreRequest $request, UserGroup $usergroup ) {
        $usergroup->fill($request->all());
		//User Information Details Submit
        $users = $request->usersId;
        $produ=" ";
             for ($i=0;$i<count($users);$i++)
             {

                    $produ .= $users[$i]." ";

            }	
        $usergroup->usersId = $produ;
        $usergroup->save();
        return response()->json([
            'status' => true,
            'data' => $usergroup
        ]);
    }

    /**
     * Store new resource
     *
     * @param ClientStoreRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store( UserGroupStoreRequest $request ) {
        $usergroup = new UserGroup;
        $usergroup->fill($request->all());
        //User Id Generate Dynamically.
        $year = date("Y");
        $year = substr( $year, -2);
        $month = date("m");
        //Fetch last company id from CompanyMaster
        $lastuserid=DB::table('usergroup')
       ->select('usergroup.groupId')->OrderBy('usergroup.groupId', 'DESC')->first();
        if($lastuserid==NULL){
           
            $bId = "1";
		}
		else{
            $lastuserid = $lastuserid->groupId;
            $lastuserid = substr( $lastuserid, -6);
            $sequence = $lastuserid + 1;
            $bId = $sequence;
		}
       
        //User Information Details Submit
        $users = $request->usersId;
        $produ=" ";
             for ($i=0;$i<count($users);$i++)
             {

                    $produ .= $users[$i]." ";

            }	
        $usergroup->groupId = $bId;
        $usergroup->usersId = $produ;
        $usergroup->save();

        return response()->json([
            'status' => true,
            'created' => true,
            'data' => [
                'id' => $bId
            ]
        ]);
    }

    /**
     * Destroy single resource
     *
     * @param CompanyMaster $companymaster
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroy( UserGroup $usergroup ) {
       
        $usergroup->delete();
        //echo "amar";
        return response()->json([
            'status' => true
        ]);
    }

    /**
     * Destroy resources by ids
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public function destroyMass( Request $request ) {
        $request->validate([
            'ids' => 'required|array'
        ]);

        UserMaster::destroy($request->ids);

        return response()->json([
            'status' => true
        ]);
    }
}
