@extends('inventory.layout') 
@section('title', 'Edit Check List')
@section('content')
    <!-- push external head elements to head -->
    @push('head')
        <link rel="stylesheet" href="{{ asset('plugins/select2/dist/css/select2.min.css') }}">
       <link rel="stylesheet" href="{{ asset('plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css') }}">
         <link rel="stylesheet" href="{{ asset('plugins/mohithg-switchery/dist/switchery.min.css') }}">
        <style type="text/css">
            .gsterror{
                color: red;
            }
            .emailerror{
                color: red;
            }
            .gstverify{
                color: #4b9732;
            }
            .protable{
                overflow-x: auto;
            }
        </style>
    @endpush

    
    <div class="container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <!-- <i class="ik ik-user-plus bg-blue"></i> -->
                        <div class="d-inline">
                            <h5>{{ __('Edit Check List')}}</h5>
                            <span>{{ __('Edit check list')}}</span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">{{ __('Edit Check List')}}</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <form class="forms-sample" method="POST" action="{{ route('checklist.update',$checklist->id) }}" enctype= multipart/form-data id="Postform">
        @csrf
        @include('include.message')
        @Method('PUT')

            <div class="row">
                <!-- start message area-->
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-header">
                            <strong><h3>{{ __('Basic Information')}}</h3></strong>
                        </div>
                        <div class="card-body">
                            
                            <div class="row">
                            
                                <div class="col-sm-6">    
                                    <div class="form-group">
                                        <label for="post_name">Title<span class="text-red">*</span></label>
                                        <input id="post_id" type="hidden" class="form-control" name="post_id" value="{{isset($checklist->post_id) ? $checklist->post_id:''}}" >

                                        <input id="title" type="text" class="form-control" name="title" value="{{isset($checklist->title) ? $checklist->title:''}}" placeholder="Enter Title" required="">
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="description">Description</label>
                                        <textarea class="form-control description" name="description" rows="2">{{isset($checklist->description) ? $checklist->description:''}}</textarea>
                                    </div>
                                </div>

                                {{--<div class="col-sm-6">    
                                    <div class="form-group">
                                        <label for="post_name">Media Library</label>
                                        <select  class="form-control " name="medialibrary_id" id="medialibrary">
                                            <option value="">Please Select</option>
                                            @foreach($medias as $media)
                                                @if($media->id==$checklist->medialibrary_id)
                                                    <option value="{{$media->id}}" selected="true">{{isset($media->title) ? $media->title:''}}</option>
                                                @else
                                                    <option value="{{$media->id}}">{{isset($media->title) ? $media->title:''}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>
                                </div>--}}

                                {{--<div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="post_name">Completed</label>
                                        <select  class="form-control " name="completed" id="completed">
                                            <option value="">Please Select</option>
                                            @if($checklist->listdetail->completed =='yes' || $checklist->listdetail->completed =='no')
                                                <option value="yes" {{ ($checklist->listdetail->completed) == 'yes' ? 'selected' : '' }}>Yes</option>
                                                <option value="no" {{ ($checklist->listdetail->completed) == 'no' ? 'selected' : '' }}>No</option>
                                            @else
                                                <option value="yes">Yes</option>
                                                <option value="no">No</option>
                                            @endif
                                        </select>
                                    </div>
                                </div>

                                

                                <div class="col-sm-6">
                                    <div class="form-group">
                                    <label for="post_name">Completed Date </label>
                                    <input id="date" type="date" class="form-control" name="date_completed" value="{{isset($checklist->listdetail->date_completed) ? $checklist->listdetail->date_completed:''}}">
                                    </div>
                                </div>--}}

                                

                                
                            </div>  
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- start message area-->
                
                <!-- end message area-->
                <div class="col-md-12">
                    <div class="card ">
                        <div class="card-body">
                            <div class="col-md-12" style="text-align: center;">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">{{ __('Update')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <!-- push external js -->
    @push('script') 
    
    <script src="{{ asset('plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js') }}"></script>
        <script src="{{ asset('plugins/jquery.repeater/jquery.repeater.min.js') }}"></script>
    <script src="{{ asset('plugins/mohithg-switchery/dist/switchery.min.js') }}"></script>
    <script src="{{ asset('js/form-advanced.js') }}"></script>
    
 

     
    @endpush
@endsection
