<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\PostController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\MediaController;
use App\Http\Controllers\DocumentController;
use App\Http\Controllers\PacksController;
use App\Http\Controllers\TenantController;
use App\Http\Controllers\ChecklistController;
use App\Http\Controllers\RolesController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\User\UserChecklistController;
use App\Http\Controllers\FormsController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\RoutingController;
use App\Http\Controllers\StepsController;
use App\Http\Controllers\StageController;
use App\Http\Controllers\AssignFormController;
use App\Http\Controllers\User\UserOrderController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/ 



Route::get('login', [LoginController::class,'showLoginForm'])->name('login');
Route::post('login', [LoginController::class,'login']);
Route::post('register', [RegisterController::class,'register']);
Route::get('/saveotp',  [RegisterController::class,'saveotp'])->name('otp.save');
Route::get('/auth/google', [GoogleController::class, 'redirectToGoogle']);
Route::get('auth/google/callback', [GoogleController::class, 'handleGoogleCallback']);

// ---------------------- START : User Login/register  Route ---------------------//

Route::get('storedate',[UserChecklistController::class,'storedate'])->name('storedate');

Route::get('search',[UserChecklistController::class,'search'])->name('search');

Route::get('user/dashboard', ['as' => 'user.dashboard', 'uses' => 'User\DashboardController@index' ]);

Route::get('user/login', ['as' => 'user.login', 'uses' => 'User\Auth\LoginController@showLoginForm' ]);
Route::post('user/login', 'User\Auth\LoginController@login');

Route::get('user/logout', ['as'=>'user.logout', 'uses'=>'User\Auth\LoginController@logout']);
/**/

Route::get('routingform/{id}',[UserOrderController::class,'routingform'])->name('routingform');

Route::get('customers',[UserOrderController::class,'customers'])->name('customers');
;

Route::get('orderindex/{id}',[UserOrderController::class,'orderindex'])->name('orderindex');
;

Route::resource('userorder', '\App\Http\Controllers\User\UserOrderController');
/**/
/**/

Route::put('updateuserform/{id}', [UserChecklistController::class,'updateuserform'])->name('updateuserform');

Route::get('assignform/{id}', [UserChecklistController::class,'assignform'])->name('assignform');

Route::get('viewchecklist/{id}', [UserChecklistController::class,'viewchecklist'])->name('viewchecklist');

Route::resource('userchecklist', '\App\Http\Controllers\User\UserChecklistController');
/**/

Route::get('password/forget',  function () { 
	return view('pages.forgot-password'); 
})->name('password.forget');
Route::post('password/email', [ForgotPasswordController::class,'sendResetLinkEmail'])->name('password.email');
Route::get('password/reset/{token}', [ResetPasswordController::class,'showResetForm'])->name('password.reset');
Route::post('password/reset', [ResetPasswordController::class,'reset'])->name('password.update');

Route::group(['middleware' => ['auth']], function() {
Route::group(['middleware' => ['verified']], function() {
Route::get('/dashboard', [DashboardController::class,'index'])->name('dashboard');
});
});




Route::group(['middleware' => 'auth'], function(){

	/**
    * Verification Routes
    */
    Route::get('/email/verify', [VerificationController::class,'show'])->name('verification.notice');
    Route::get('/email/verify/{id}/{hash}', [VerificationController::class,'verify'])->name('verification.verify')->middleware(['signed']);
    Route::post('/email/resend', [VerificationController::class,'resend'])->name('verification.resend');
	// logout route
	Route::get('/logout', [LoginController::class,'logout']);
	Route::get('/clear-cache', [HomeController::class,'clearCache']);

/* user routes start */
	//only those have manage_user permission will get access
	//Route::group(['middleware' => 'can:manage_user'], function(){
		Route::get('user/show/{id}/{userid}', [UserController::class,'show'])->name('user.show');
		Route::get('userpost/{id}', [UserController::class,'userpost'])->name('userpost');
		Route::get('usersearch', [UserController::class,'usersearch'])->name('usersearch');
		Route::get('/users', [UserController::class,'index']);
		Route::get('/user/get-list', [UserController::class,'getUserList']);
		Route::get('/user/create', [UserController::class,'create']);
		Route::post('/user/create', [UserController::class,'store'])->name('create-user');
		Route::get('/user/{id}', [UserController::class,'edit']);
		Route::post('/user/update', [UserController::class,'update']);
		Route::get('/user/delete/{id}', [UserController::class,'delete']);
	//});

/* user routes end */

/* client routes start */


Route::get('clientsearch', [ClientController::class,'clientsearch'])->name('clientsearch');

Route::get('clientdelete/{id}', [ClientController::class,'clientdelete'])->name('clientdelete');

Route::resource('client', '\App\Http\Controllers\ClientController');

/* client routes end */

Route::get('indexorder/{id}', [OrderController::class,'indexorder'])->name('indexorder');


Route::get('createorder/{id}', [OrderController::class,'createorder'])->name('createorder');

Route::get('orderdelete/{id}', [OrderController::class,'orderdelete'])->name('orderdelete');

Route::resource('order', '\App\Http\Controllers\OrderController');


/*routing*/
Route::resource('routing', '\App\Http\Controllers\RoutingController');

/**/
/*stage*/
Route::get('indexstage/{id}', [StageController::class,'indexstage'])->name('indexstage');

Route::get('createstage/{id}', [StageController::class,'createstage'])->name('createstage');

Route::resource('stage', '\App\Http\Controllers\StageController');
/**/

/*steps*/

Route::get('indexstep/{id}', [StepsController::class,'indexstep'])->name('indexstep');

Route::get('createstep/{id}', [StepsController::class,'createstep'])->name('createstep');

Route::resource('steps', '\App\Http\Controllers\StepsController');
/**/
/**/
Route::get('indexaform/{id}', [AssignFormController::class,'indexaform'])->name('indexaform');

Route::get('createaform/{id}', [AssignFormController::class,'createaform'])->name('createaform');

Route::resource('assignform', '\App\Http\Controllers\AssignFormController');

/**/
/* post routes start */

Route::get('postuser/{id}/{postid}',[PostController::class,'postuser'])->name('postuser');

Route::post('storeuser',[PostController::class,'storeuser'])->name('storeuser');

Route::get('showuser/{id}',[PostController::class,'showuser'])->name('showuser');

Route::get('postdetail/{id}',[PostController::class,'postdetail'])->name('postdetail');

Route::get('postsearch',[PostController::class,'postsearch'])->name('postsearch');

Route::get('postdelete/{id}', [PostController::class,'postdelete'])->name('postdelete');

Route::get('poststatus/{id}', [PostController::class,'poststatus'])->name('poststatus');

Route::resource('post', '\App\Http\Controllers\PostController');

/* post routes end */

/* media routes start */

Route::get('mediadelete/{id}',[MediaController::class,'mediadelete'])->name('mediadelete');
Route::Post('mediaupdate',[MediaController::class,'mediaupdate'])->name('mediaupdate');

Route::resource('media', '\App\Http\Controllers\MediaController');

/* media routes end */

/* Document routes start */

Route::get('documentdelete/{id}',[DocumentController::class,'documentdelete'])->name('documentdelete');
Route::Post('documentupdate',[DocumentController::class,'documentupdate'])->name('documentupdate');

Route::resource('documenttype', '\App\Http\Controllers\DocumentController');

/* Document routes end */

/* packs routes start */

Route::get('mediadetail/{id}',[PacksController::class,'mediadetail'])->name('mediadetail');

Route::get('mediasearch',[PacksController::class,'mediasearch'])->name('mediasearch');

Route::get('librarydelete/{id}',[PacksController::class,'librarydelete'])->name('librarydelete');

Route::resource('medialibrary', '\App\Http\Controllers\PacksController');

/* packs routes end */

/*form route start */
Route::put('updateform',[FormsController::class,'updateform'])->name('updateform');

Route::get('formdelete/{id}',[FormsController::class,'formdelete'])->name('formdelete');

Route::post('storeform',[FormsController::class,'storeform'])->name('storeform');

//Route::get('formshow',[FormsController::class,'formshow'])->name('formshow');
Route::resource('forms', '\App\Http\Controllers\FormsController');
/*form route end */

/*checklist route start */

Route::post('formuser',[ChecklistController::class,'formuser'])->name('formuser');

Route::get('displayorder/{id}',[ChecklistController::class,'displayorder'])->name('displayorder');

Route::get('detailsearch',[ChecklistController::class,'detailsearch'])->name('detailsearch');

Route::get('checkdelete/{id}',[ChecklistController::class,'checkdelete'])->name('checkdelete');


Route::get('viewdetail/{id}',[ChecklistController::class,'viewdetail'])->name('viewdetail');

Route::put('updatechecklist/{id}',[ChecklistController::class,'updatechecklist'])->name('updatechecklist');

Route::get('editchecklist/{id}',[ChecklistController::class,'editchecklist'])->name('editchecklist');

Route::post('storedetail',[ChecklistController::class,'storedetail'])->name('storedetail');

Route::get('adddetail/{id}',[ChecklistController::class,'adddetail'])->name('adddetail');

Route::get('newchecklist/{id}',[ChecklistController::class,'newchecklist'])->name('newchecklist');

Route::get('createchecklist/{id}',[ChecklistController::class,'createchecklist'])->name('createchecklist');

Route::get('listsearch',[ChecklistController::class,'listsearch'])->name('listsearch');

Route::get('listdetail/{id}',[ChecklistController::class,'listdetail'])->name('listdetail');

Route::get('listdelete/{id}',[ChecklistController::class,'listdelete'])->name('listdelete');

Route::resource('checklist', '\App\Http\Controllers\ChecklistController');

Route::get('tenantsearch',[TenantController::class,'tenantsearch'])->name('tenantsearch');

Route::get('getCity', [TenantController::class,'getCity'])->name('getCity');
Route::get('tenantdelete/{id}',[TenantController::class,'tenantdelete'])->name('tenantdelete');
Route::resource('tenant', '\App\Http\Controllers\TenantController');


/* role routes start */
	//only those have manage_role permission will get access
	//Route::group(['middleware' => 'can:manage_role|manage_user'], function(){
		
		Route::get('rolesearch', [RolesController::class,'rolesearch'])->name('rolesearch');
		Route::get('/roles', [RolesController::class,'index']);
		Route::get('/role/get-list', [RolesController::class,'getRoleList']);
		Route::post('/role/create', [RolesController::class,'create']);
		Route::get('/role/edit/{id}', [RolesController::class,'edit']);
		Route::post('/role/update', [RolesController::class,'update']);
		Route::get('/role/delete/{id}', [RolesController::class,'delete']);
	//});
/* role routes start */

/* permission routes start */

	//only those have manage_permission permission will get access
	//Route::group(['middleware' => 'can:manage_permission|manage_user'], function(){
		Route::get('permissionsearch', [PermissionController::class,'permissionsearch'])->name('permissionsearch');
		Route::get('/permission', [PermissionController::class,'index']);
		Route::get('/permission/get-list', [PermissionController::class,'getPermissionList']);
		Route::post('/permission/create', [PermissionController::class,'create']);
		Route::get('/permission/update', [PermissionController::class,'update']);
		Route::get('/permission/delete/{id}', [PermissionController::class,'delete']);
	//});


/* permission routes start */

	//only those have manage_permission permission will get access	
 
/* permission routes start */
   
	Route::get('/profile', function () { return view('pages.profile'); });
	
	/*Route::get('/products', function () { return view('inventory.product.list'); });
	Route::get('/products/create', function () { return view('inventory.product.create'); });*/

	
});


Route::get('/register', function () { return view('auth.register'); });
