<?php $__env->startSection('title', 'Roles'); ?>
<?php $__env->startSection('content'); ?>
    <!-- push external head elements to head -->
    <?php $__env->startPush('head'); ?>
        <link rel="stylesheet" href="<?php echo e(asset('plugins/DataTables/datatables.min.css')); ?>">
    <?php $__env->stopPush(); ?>


    <div class="container-fluid">
    	<div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <i class="ik ik-award bg-blue"></i>
                        <div class="d-inline">
                            <h5><?php echo e(__('Roles')); ?></h5>
                            <span><?php echo e(__('Define roles of user')); ?></span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../index.html"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#"><?php echo e(__('Roles')); ?></a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <div class="row clearfix">
	        <!-- start message area-->
            <?php echo $__env->make('include.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- end message area-->
            <!-- only those have manage_role permission will get access -->
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage_role')): ?>
			<div class="col-md-12">
                <div class="mb-2 clearfix">
                    <a class="btn pt-0 pl-0 d-md-none d-lg-none" data-toggle="collapse" href="#displayOptions" role="button" aria-expanded="true" aria-controls="displayOptions">
                        <?php echo e(__('Display Options')); ?>

                        <i class="ik ik-chevron-down align-middle"></i>
                    </a>
                    <div class="collapse d-md-block display-options" id="displayOptions">
                        <div class="d-block d-md-inline-block">
                            
                            <div class="search-sm d-inline-block float-md-left mr-1 mb-1 align-top">
                                <form action="<?php echo e(url('roles')); ?>" method="get">
                                    <input type="text" class="form-control" id="search" placeholder="Search.." name="name" value="<?php echo e(Request::input('name')); ?> ">
                                    <button type="submit" class="btn btn-icon"><i class="ik ik-search"></i></button>
                                    
                                    <a href="<?php echo e(url('roles')); ?>" ><button type="button"  class="adv-btn closeicon" ><i class="fa fa-window-close" aria-hidden="true"></i></button></a>
                                    <div class="adv-search-wrap dropdown-menu dropdown-menu-right" aria-labelledby="adv_wrap_toggler">
                                        <div class="form-group">
                                            <input type="text" class="form-control" placeholder="Category Title">
                                        </div>
                                        
                                        <button class="btn btn-theme"><?php echo e(__('Search')); ?></button>
                                    </div>
                                </form> 
                            </div>
                        </div>
                        
                        <div class="float-md-right">

                    
                            <button class="btn btn-outline-primary btn-rounded-20" href="#rolesAdd" data-toggle="modal" data-target="#rolesAdd">
                                Add Role
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
		</div>
		<div class="row">
	        <div class="col-md-12">
	            <div class="card p-3">
	                <div class="card-header"><h3><?php echo e(__('Roles')); ?></h3></div>
	                <div class="card-body">
                        <table id="roles_table" class="table">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Role')); ?></th>
                                    <th><?php echo e(__('Permissions')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <tr>
                                    <td><?php echo e(isset($role->name) ? $role->name :''); ?></td>
                                    <td>
                                        <?php if($role->name == 'Super Admin'): ?> 
                                            <span class="badge badge-success m-1">All permissions</span>
                                        <?php endif; ?>
                                    <?php $__currentLoopData = $role->permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $per): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <span class="badge badge-dark m-1"><?php echo e(isset($per->name) ? $per->name :''); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td>
                                     <a href="javascript:;"  class="editroleid"  data-id="<?php echo e($role->id); ?>" data-url="<?php echo e(url('role/edit/' . $role->id)); ?>"><i class="ik ik-edit-2 f-16 mr-15 text-green"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    <a href="javascript:;" class="deletebyid" data-id="<?php echo e(isset($role->id) ? $role->id:''); ?>"  data-url="<?php echo e(url('role/delete/'.$role['id'])); ?>"><i class="ik ik-trash-2 f-16 text-red"></i></a></td>
                                  </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                             
                            </tbody>
                        </table>
                            <div class="card-footer d-flex align-items-center">
                                    <div class="col-md-6">
                                        Showing <?php echo e(($roles->currentpage()-1)*$roles->perpage()+1); ?> to <?php echo e($roles->currentpage()*$roles->perpage()); ?>

                                            of  <?php echo e($roles->total()); ?> entries
                                    </div>
                                        
                                        <div class="col-md-6">
                                            <?php echo e($roles->links('include.pagination')); ?>

                                        </div>
                            </div>
	                    
	                </div>
	            </div>
	        </div>
	    </div>
    </div>
    <div class="modal fade edit-layout-modal pr-0 " id="rolesAdd" tabindex="-1" role="dialog" aria-labelledby="rolesAddLabel" aria-hidden="true">
        <div class="modal-dialog w-300" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="categoryAddLabel"><?php echo e(__('Add Role')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <form class="forms-sample" method="POST" action="<?php echo e(url('role/create')); ?>">
	                    	<?php echo csrf_field(); ?>
	                        <div class="modal-body">
	                            
                                <div class="form-group">
                                    <label for="role"><?php echo e(__('Role')); ?><span class="text-red">*</span></label>
                                    <input type="text" class="form-control is-valid" id="role" name="name" placeholder="Role Name" required>
                                
                            	</div>
	                            <div class="form-group">
	                                <label for="exampleInputEmail3"><?php echo e(__('Assign Permission')); ?> </label>
	                                
	                                	<?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
	                                	
                                            <label class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" id="item_checkbox" name="permissions[]" value="<?php echo e($key); ?>">
                                                <span class="custom-control-label">
                                                	
                                                	<?php echo e(clean($permission,'titles')); ?>

                                                </span>
                                            </label>

	                                	
	                                	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	                                </div>

	                                <div class="form-group">
	                                	<button type="submit" class="btn btn-primary btn-rounded"><?php echo e(__('Save')); ?></button>
	                                </div>
	                            </div>
	                       
            	</form>
            </div>
        </div>
    </div>

    <!-- role edit modal -->
    <div class="modal fade edit-layout-modal pr-0 " id="roledit" tabindex="-1" role="dialog" aria-labelledby="roleditLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog w-300" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="categoryViewLabel"><?php echo e(__('Edit Role')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <form class="forms-sample" method="POST" action="<?php echo e(url('role/update')); ?>">
                        <?php echo csrf_field(); ?>
                        
                            <div class="modal-body roleper">
                                <div class="form-group ">
                                    <label for="role"><?php echo e(__('Role')); ?><span class="text-red">*</span></label>
                                    <input type="text" class="form-control is-valid rolename" id="role" name="name" value="" placeholder="Insert Role">
                                    <input type="hidden" name="id" class="roleid" value="" required>
                                </div>
                           
                                <label for="exampleInputEmail3"><?php echo e(__('Assign Permission')); ?> </label>
                                <div id='permissiondiv' class="row appendpermission">
                                	
                                
                                </div>
                                <div class="form-group">
                                	<button type="submit" class="btn btn-primary btn-rounded"><?php echo e(__('Update')); ?></button>
                                </div>
                            </div>
                       
                </form>
            </div>
        </div>
    </div>
    <!-- push external js -->
    <?php $__env->startPush('script'); ?>
    <!-- <script src="<?php echo e(asset('plugins/DataTables/datatables.min.js')); ?>"></script> -->
    <script src="<?php echo e(asset('plugins/select2/dist/js/select2.min.js')); ?>"></script>
    <!--server side roles table script-->
   <!--  <script src="<?php echo e(asset('js/custom.js')); ?>"></script> -->
   
   <script src="<?php echo e(url('js/global.js')); ?>"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
<script src = "http://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>
<script type="text/javascript">

    var route = "<?php echo e(url('rolesearch')); ?>";
 $('#search').typeahead({
            source: function (query, process) {
                return $.get(route, {
                    query: query
                }, function (data) {
                    return process(data);
                });
            }
        });
var table = $('#roles_table').DataTable({

        paging: false,
        ordering: true,
        info: false,
        searching:false,
    });

</script>
	<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('inventory.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cdapp/trading.cdapp.in/resources/views/roles.blade.php ENDPATH**/ ?>